package com.printer.sdk.demo.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

public class SpUtil {

    private static final String name = "printer";
    private static final int sp_name = Context.MODE_PRIVATE;

    public static boolean put(Context mContext,String key, Object value) {
        SharedPreferences sharedPreferences = mContext.getSharedPreferences(name, sp_name);
        SharedPreferences.Editor edit = sharedPreferences.edit();

        if (value instanceof String) {
            if (!TextUtils.isEmpty((CharSequence) value)) {
                edit.putString(key, (String) value);
            }
        } else if (value instanceof Boolean) {
            edit.putBoolean(key, (Boolean) value);
        } else if (value instanceof Float) {
            edit.putFloat(key, (Float) value);
        } else if (value instanceof Float) {
            edit.putFloat(key, (Float) value);
        } else if (value instanceof Integer) {
            edit.putInt(key, (Integer) value);
        } else {
            edit.putLong(key, (Long) value);
        }

        return edit.commit();
    }

    public static String getString(Context mContext,String key, String array) {
        SharedPreferences sharedPreferences = mContext.getSharedPreferences(name, sp_name);
        return sharedPreferences.getString(key, array);
    }

    public static int getInt(Context mContext,String key, int defaultVal) {
        SharedPreferences preferences = mContext.getSharedPreferences(name, sp_name);
        return preferences.getInt(key, defaultVal);
    }

    public static boolean getSb(Context mContext,String key, boolean defaultVal) {
        SharedPreferences preferences = mContext.getSharedPreferences(name, sp_name);
        return preferences.getBoolean(key, defaultVal);
    }

    public static long getLong(Context mContext,String key, long defaultVal) {
        SharedPreferences preferences = mContext.getSharedPreferences(name, sp_name);
        return preferences.getLong(key, defaultVal);
    }

    public static void remove(Context mContext,String key) {
        SharedPreferences sharedPreferences = mContext.getSharedPreferences(name, sp_name);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove(key);
        editor.apply();
    }

}
