package com.printer.sdk.demo.ui;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ScrollView;

import com.printer.sdk.demo.databinding.ActivityTestConnectBinding;
import com.printer.sdk2.ConnectionListener;
import com.printer.sdk2.Printer;
import com.printer.sdk2.PrinterResponse;
import com.printer.sdk2.model.Instruction;
import com.printer.sdk2.model.PrinterState;
import com.printer.sdk2.model.WifiPrinterDevice;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TestConnectActivity extends AppCompatActivity implements ConnectionListener {

    private ActivityTestConnectBinding binding;
    private int delay = 0;
    private boolean startTest = false;
    private WifiPrinterDevice wifiPrinter = new WifiPrinterDevice();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private StringBuilder log = new StringBuilder();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivityTestConnectBinding.inflate(getLayoutInflater(), null, false);
        binding.toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        setContentView(binding.getRoot());
        Printer.addConnectionListener(this);
    }

    public void onClickClearLog(View view) {
        log.setLength(0);
        binding.tvLog.setText(log.toString());
    }

    public void onClickTest(View view) {
        startTest = !startTest;
        if (startTest) {
            ((Button) view).setText("停止测试");
            String ip = binding.etIp.getText().toString();
            String delayStr = binding.etDelay.getText().toString();
            if (!delayStr.trim().isEmpty()) {
                delay = Integer.parseInt(delayStr);
            } else {
                delay = 0;
            }
            wifiPrinter.setIp(ip);
            wifiPrinter.setPort(9100);
            startTest();
        } else {
            ((Button) view).setText("开始测试");
        }
    }
    private void startTest() {
        if (startTest) {
            if (delay > 0) {
                try {
                    TimeUnit.MILLISECONDS.sleep(delay);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Printer.connect(wifiPrinter);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Printer.removeConnectionListener(this);
    }

    @Override
    public void onPrinterConnected(Printer printer) {
        log.append(dateFormat.format(new Date())).append(" printer connected.\n");
        binding.tvLog.setText(log.toString());
        binding.scrollview.fullScroll(ScrollView.FOCUS_DOWN);
        printer.getPrinterStatus(Instruction.ESC, new PrinterResponse<PrinterState>() {
            @Override
            public void onPrinterResponse(PrinterState printerState) {
                if (printerState == null) {
                    log.append(dateFormat.format(new Date())).append(" printer status: timeout.\n");
                } else {
                    log.append(dateFormat.format(new Date())).append(String.format(" printer status: %d.\n", printerState.getStatus()));
                }
                binding.scrollview.fullScroll(ScrollView.FOCUS_DOWN);
                printer.disconnect();
                startTest();
            }
        });
    }

    @Override
    public void onPrinterConnectFail(Printer printer) {
        log.append(dateFormat.format(new Date())).append(" printer connect failed.\n");
        binding.tvLog.setText(log.toString());
        binding.scrollview.fullScroll(ScrollView.FOCUS_DOWN);
        startTest();
    }

    @Override
    public void onPrinterDisconnect(Printer printer) {
        log.append(dateFormat.format(new Date())).append(" printer disconnected failed.\n");
        binding.tvLog.setText(log.toString());
        binding.scrollview.fullScroll(ScrollView.FOCUS_DOWN);
    }

}