package com.printer.sdk.demo.ui;

import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.printer.sdk.demo.App;
import com.printer.sdk.demo.R;
import com.printer.sdk.demo.bean.Constants;
import com.printer.sdk.demo.bean.SettingParam;
import com.printer.sdk.demo.util.SpUtil;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class PrinterSettingActivity extends AppCompatActivity {

    TextView tvDpi200, tvDpi300, tvSpeed, tvPaper, tvConcentration;
    List<String> speedList = new ArrayList<>();
    List<String> paperList = new ArrayList<>();
    List<String> concentrationList = new ArrayList<>();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_printer_setting);

        tvDpi200 = findViewById(R.id.tv_dpi_200);
        tvDpi300 = findViewById(R.id.tv_dpi_300);

        int dpi = SpUtil.getInt(App.app, Constants.KEY_PRINT_DPI, 0);
        if (200 == dpi) {
            tvDpi200.setSelected(true);
        } else if (300 == dpi) {
            tvDpi300.setSelected(true);
        }

        tvDpi200.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                tvDpi200.setSelected(true);
                tvDpi300.setSelected(false);
                SpUtil.put(App.app, Constants.KEY_PRINT_DPI, 200);
            }
        });

        tvDpi300.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                tvDpi300.setSelected(true);
                tvDpi200.setSelected(false);
                SpUtil.put(App.app, Constants.KEY_PRINT_DPI, 300);
            }
        });

        tvSpeed = findViewById(R.id.tv_speed);
        getSpeedList();
        int speed = SpUtil.getInt(App.app, Constants.KEY_PRINT_SPEED, 0);
        NumberFormat formatter = new DecimalFormat("0.0");
        tvSpeed.setText(speed==0 ? "" : formatter.format(speed*25.4) + " 毫米/秒");
        findViewById(R.id.ll_speed).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                BottomListDialog dialog = new BottomListDialog(PrinterSettingActivity.this);
                dialog.setData(speedList);
                dialog.show();
                dialog.setOnItemClick(new AdapterView.OnItemClickListener() {
                    @Override
                    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                        String item = speedList.get(position);
                        tvSpeed.setText(item);
                        SpUtil.put(App.app, Constants.KEY_PRINT_SPEED, position+2);
                        dialog.dismiss();
                    }
                });
            }
        });

        tvPaper = findViewById(R.id.tv_paper);
        getPaperList();
        int paper = SpUtil.getInt(App.app, Constants.KEY_PRINT_PAPER_TYPE, 1);
        if (paper == SettingParam.PAPER_TYPE_CONTINUOUS) {
            tvPaper.setText("连续纸");
        } else if (paper == SettingParam.PAPER_TYPE_INTERVAL) {
            tvPaper.setText("间隙纸");
        } else if (paper == SettingParam.PAPER_TYPE_BLACK) {
            tvPaper.setText("黑标纸");
        }
        findViewById(R.id.ll_paper).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                BottomListDialog dialog = new BottomListDialog(PrinterSettingActivity.this);
                dialog.setData(paperList);
                dialog.show();
                dialog.setOnItemClick(new AdapterView.OnItemClickListener() {
                    @Override
                    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                        String item = paperList.get(position);
                        tvPaper.setText(item);
                        if ((position + 1) == SettingParam.PAPER_TYPE_CONTINUOUS) {
                            tvPaper.setText("连续纸");
                        } else if ((position + 1) == SettingParam.PAPER_TYPE_INTERVAL) {
                            tvPaper.setText("间隙纸");
                        } else if ((position + 1) == SettingParam.PAPER_TYPE_BLACK) {
                            tvPaper.setText("黑标纸");
                        }
                        SpUtil.put(App.app, Constants.KEY_PRINT_PAPER_TYPE, (position + 1));
                        dialog.dismiss();
                    }
                });
            }
        });


        tvConcentration = findViewById(R.id.tv_concentration);
        getConcentrationList();
        int density = SpUtil.getInt(App.app, Constants.KEY_PRINT_DENSITY, -1);
        tvConcentration.setText(density < 0 ? "" : density + "");
        findViewById(R.id.ll_concentration).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                BottomListDialog dialog = new BottomListDialog(PrinterSettingActivity.this);
                dialog.setData(concentrationList);
                dialog.show();
                dialog.setOnItemClick(new AdapterView.OnItemClickListener() {
                    @Override
                    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                        String item = concentrationList.get(position);
                        tvConcentration.setText(item);
                        SpUtil.put(App.app, Constants.KEY_PRINT_DENSITY, position);
                        dialog.dismiss();
                    }
                });
            }
        });
    }

    private void getSpeedList() {
        NumberFormat formatter = new DecimalFormat("0.0");
        speedList = new ArrayList<>();
        for (int i = 2; i <= 12; i++) {
            speedList.add( formatter.format(i * 25.4) + " 毫米/秒");
        }
    }

    private void getPaperList() {
        paperList = new ArrayList<>();
        paperList.add("连续纸");
        paperList.add("间隙纸");
        paperList.add("黑标纸");
    }

    private void getConcentrationList() {
        concentrationList = new ArrayList<>();
        for (int i = 0; i < 15; i++) {
            concentrationList.add(i + "");
        }
    }

}
