package com.printer.sdk.demo.ui;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.printer.sdk.demo.R;

public class PdfFileActivity extends AppCompatActivity {

    private int REQUEST_CODE_FILE = 88;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_pdf_file);

        findViewById(R.id.tv_choose).setOnClickListener(view -> chooseFile());

    }

    private void chooseFile() {
        Intent intent = new Intent();
        intent.setType("pdf/*");
        intent.setAction(Intent.ACTION_GET_CONTENT);
        startActivityForResult(intent, REQUEST_CODE_FILE);
    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == REQUEST_CODE_FILE && resultCode == RESULT_OK
                && null != data) {
            Uri selectedPdf = data.getData();
            if (selectedPdf == null) return;
            if (selectedPdf.getLastPathSegment().endsWith("pdf")) {
                System.out.println("Uri of selected pdf---->" + selectedPdf.toString());
                toPreview(selectedPdf);
            } else {
                Toast.makeText(this, "Invalid file type", Toast.LENGTH_SHORT).show();
            }
        }
    }

    private void toPreview(Uri uri) {
        Intent intent = new Intent(this, PdfPreviewActivity.class);
        intent.putExtra("pdf", uri);
        startActivity(intent);
        finish();
    }
}
