package com.printer.sdk.demo.ui;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.Gravity;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import androidx.annotation.NonNull;

import com.printer.sdk.demo.R;

import java.util.List;

public class BottomListDialog extends Dialog {

    ListView lv;
    ArrayAdapter<String> adapter;

    public BottomListDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.layout_dialog_bottom);
        lv = findViewById(R.id.lv);
        findViewById(R.id.tv_cancel).setOnClickListener(v -> dismiss());

        Window window = getWindow();
        //设置弹出位置
        window.setGravity(Gravity.BOTTOM);
        //设置对话框大小
        window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT);

        lv.setAdapter(adapter);
    }


    public void setData(List<String> data){
        if(adapter==null){
            adapter = new ArrayAdapter<>(getContext(),R.layout.item_bottom_list,R.id.tv_item);
        }
        adapter.addAll(data);
    }

    public void setOnItemClick(AdapterView.OnItemClickListener listener){
        lv.setOnItemClickListener(listener);
    }


}
