package com.printer.sdk.demo.ui;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;

import androidx.annotation.NonNull;

import com.printer.sdk.demo.R;

public class BottomInputDialog extends Dialog {


    Button btnPrint;
    EditText etWidth,etHeight,etStart;
    public BottomInputDialog(@NonNull Context context) {
        super(context);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.layout_dialog_input);

        findViewById(R.id.btn_cancel).setOnClickListener(v -> dismiss());

        btnPrint = findViewById(R.id.btn_print);
        etStart = findViewById(R.id.et_start);
        etHeight = findViewById(R.id.et_height);
        etWidth = findViewById(R.id.et_width);

        Window window = getWindow();
        //设置弹出位置
        window.setGravity(Gravity.BOTTOM);
        //设置对话框大小
        window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT,ViewGroup.LayoutParams.WRAP_CONTENT);

    }

    public void setBtnPrintClick(View.OnClickListener listener){
        btnPrint.setOnClickListener(listener);
    }

    public int getStartPageIndex(){
        String text = etStart.getText().toString().trim();
        if(TextUtils.isEmpty(text)) return 1;
        return Integer.parseInt(text);
    }

    public int getWidthInput(){
        String text = etWidth.getText().toString().trim();
        if(TextUtils.isEmpty(text)) return 80;
        return Integer.parseInt(text);
    }

    public int getHeightInput(){
        String text = etHeight.getText().toString().trim();
        if(TextUtils.isEmpty(text)) return 60;
        return Integer.parseInt(text);
    }


}
