package com.printer.sdk.demo.bean

class SettingParam : Cloneable {
    /**打印份数 */
    var printCount = 1

    /**标签宽度 */
    var labelWidth = 60

    /**标签高度 */
    var labelHeight = 40

    /**标间间距 */
    var labelSpace = 2

    /**黑标高度 */
    var blineHeight = 0

    /**打印速度 */
    var printSpeed = 4

    /**打印浓度 */
    var printConcentration = 8

    /**打印方向 */
    var printDirection = 0

    /**纸张类型 */
    var paperType: Int = PAPER_TYPE_INTERVAL

    /**打印分辨率 */
    var dpi = 200

    /**高速打印 */
    var printHighSpeed: Int = PRINT_HIGH_SPEED_OFF

    /**响应模式 */
    var isResponseMode: Boolean = false
    var tearMode = TEAR_TEAR

    /**声音 */
    var isSound = false

    /**图片处理 */
    var pictureProcess: Int = PICTURE_PROCESS_DEFAULT

    /**默认字体大小 */
    var defaultFontSize: Float = 16f

    /**指令集 */
    var instruction: Int = INSTRCUTION_TSC

    /**水平移动位置偏移量 */
    var levelReference: Int = 0

    /**垂直移动位置偏移量 */
    var verticalReference: Int = 0

    /**多列打印，列数 */
    var multiColumnSize: Int = 1

    /**多列打印，列间隔，mm */
    var multiColumnDividerSpace: Int = 0

    /**压缩打印内容 */
    var isCompressContent: Boolean = false

    /**串口波特率*/
    var serialPortBaudRate = 9600

    var ribbonOn = false

    companion object {
        //连续纸
        const val PAPER_TYPE_CONTINUOUS = 1

        //间隙纸
        const val PAPER_TYPE_INTERVAL = 2

        //黑标纸
        const val PAPER_TYPE_BLACK = 3

        //关闭高速打印
        const val PRINT_HIGH_SPEED_OFF = 1

        //开启高速打印，默认方式
        const val PRINT_HIGH_SPEED_DEFAULT = 2

        //开启高速打印，抖动方式
        const val PRINT_HIGH_SPEED_SHAKE = 3

        //图片处理：默认
        const val PICTURE_PROCESS_DEFAULT = 1

        //图片处理：黑白
        const val PICTURE_PROCESS_BLACK_WHITE = 2

        //图片处理：抖动
        const val PICTURE_PROCESS_SHAKE = 3
        const val INSTRCUTION_TSC = 1
        const val INSTRUCTION_ESC = 2
        const val INSTRUCTION_ZPL = 3
        const val INSTRUCTION_CPCL = 4
        const val CUT_MODEL_ONE = 1
        const val CUT_MODEL_TWO = 2
        const val DPI_200 = 200
        const val DPI_300 = 300
        const val TEAR_TEAR = 0
        const val TEAR_PEEL = 1
        const val TEAR_CUT = 2
        const val TEAR_CUT_END = 3

        //版本3的模板大小毫米转换为屏幕像素的比例
        const val LABEL_BOARD_SCREEN_SCALE = 16
    }

    public override fun clone(): SettingParam {
        return super.clone() as SettingParam
    }
}