package com.printer.sdk.demo.adapter;

import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.printer.sdk.demo.R;
import com.printer.sdk.demo.bean.Triple;

import java.util.List;

public class ViewPagerAdapter extends RecyclerView.Adapter<ViewPagerAdapter.ViewPagerHolder> {

    private List<Triple> mDataList;


    public ViewPagerAdapter(List<Triple> data){
        mDataList = data;
    }

    public List<Triple> getDataList(){
        return mDataList;
    }

    @NonNull
    @Override
    public ViewPagerAdapter.ViewPagerHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new ViewPagerHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.item_pager, parent, false));
    }

    @Override
    public void onBindViewHolder(@NonNull ViewPagerHolder holder, int position) {
       Bitmap bitmap = mDataList.get(position).bitmap;

        Glide.with(holder.img.getContext())
                .load(bitmap)
                .into(holder.img);
    }


    @Override
    public int getItemCount() {
        return mDataList.size();
    }


    class ViewPagerHolder extends RecyclerView.ViewHolder{
        ImageView img;

        public ViewPagerHolder(@NonNull View itemView) {
            super(itemView);
            img = itemView.findViewById(R.id.img);
        }
    }
}

