//
//  PrintfTSPLManager.h
//  DemoLabel
//
//  Created by Mac on 12/28/20.
//  Copyright © 2020 label printf demo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BluetoothManager.h"
#import <UIKit/UIImage.h>
NS_ASSUME_NONNULL_BEGIN

@interface PrintfTSPLManager : NSObject

/**
 * 清除画布
 * clear Canvas
 */
+ (NSData *)clearCanvas;

/**
 * 初始化画布
 * Initialization canvas
 */
+ (NSData *)initCanvas:(int)width height:(int)height;


/**
 * 设置打印方向
 */
+ (NSData *)setDirection:(int)direction;

/**
 *   打印文字
 *  x：文字x坐标
 *  y:   文字y坐标
 *  fontWidth：字体宽度（1-10）
 *  fontHeight：字体高度（1-10）
 *  content：打印内容
 */
+(NSData *)printText:(int)x y:(int)y fontWidth:(int)fontWidth fontHeight:(int)fontHeight content:(NSString *)content;


/**
 * 打印条形码
 * x：条形码x坐标
 * y：条形码y坐标
 * codeType：条形码类型（CODE128：“128”，UPCA：“UPCA”，EAN13：“EAN13”，EAN8：“EAN8”，CODE39：“39”，C0DABAR:“CODA”）
 * height：条形码高度(dots)
 * narrow：窄条码比例（可用于调整条码宽度）
 * barcodeTextAlign：条形码文字位置(NONE:0，LEFT：1，CENTER：2，RIGHT：3）
 * rotation：旋转（ROTATION：0，90，180，270）
 * content：打印内容
 */
+(NSData *)printBarCode:(int)x y:(int)y codeType:(NSString *)barCodeType height:(int)height
 narrow:(int)narrow barcodeTextAlign:(int)textAlign rotation:(int)rotation content:(NSString *)content;

/**
 *打印二维码
 *x：二维码x坐标
 *y：二维码y坐标
 *level：“L”，“M”，“Q”，“H”
 *rotation：旋转角度（0，90，180，270）
 *content：内容
 */
+(NSData *)printQRCode:(int)x y:(int)y level:(NSString *)level width:(int)width rotation:(int)rotation content:(NSString *)content;

/**
 * 图片 已经出来过大小的UIImage
 *
 * x: 图片x坐标
 * y: 图片y坐标
 * image:图片UIImage
 */
+(NSData *)printImage:(int)x y:(int)y image:(UIImage *)image;


/**
 * 开始打印
 *  number:打印的张数
 */
+ (NSData *)beginPrint:(int)number;

@end

NS_ASSUME_NONNULL_END
