//
//  BluetoothManager.h
//  BluetoothManager
//
//  Created by Mac on 1/11/21.
//

#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>

NS_ASSUME_NONNULL_BEGIN

@interface BluetoothManager : NSObject<CBCentralManagerDelegate,CBPeripheralDelegate>

//单个实例
+(instancetype) bluetoothManagerInstance;

//读取数据的闭包
typedef void (^ReadNSData)(NSData *nsData);

//读取打印设备数据回调
@property (strong,nonatomic) ReadNSData readNSData;


//扫描到设备的回调闭包
- (void)blePeripheralFound:(void (^)(CBPeripheral *peripheral))block;

//连接设备成功的回调闭包
- (void)blePeripheralConnected:(void (^)(CBCentralManager *central,CBPeripheral *peripheral))block;

//设备断开的回调闭包
- (void)blePeripheralDisonnected:(void (^)(CBCentralManager *central,CBPeripheral *peripheral))block;

/**
 * 开始扫描
 */
-(void)beginScan;

/**
 * 停止扫描
 */
-(void)stopScan;

/**
 * 连接蓝牙
 */
-(void)connect:(CBPeripheral *)peripheral;

/**
 *写入NSData数据
 */
-(BOOL)writeNSData:(NSData *)nsData;

/**
 * 写入Data数据并通过block 回调读取结果
 */
-(void)writeAndRead:(NSData *)nsData readNSData:(ReadNSData) readNSData;


//是否已经连接
-(BOOL)isConnected;

/**
 * 得到当前连接的蓝牙名称
 */
-(NSString *)getCurrentName;


@end

NS_ASSUME_NONNULL_END

