//
//  ViewController.m
//  TestPrint
//
//  Created by Mac on 12/28/20.
//

#import "ViewController.h"
#import "BluetoothManager.h"
#import "BluetoothController.h"
#import "PrintfTSPLManager.h"

@interface ViewController ()

@property (strong,nonatomic) UILabel *blueNameUILabel;

@property (strong,nonatomic) UILabel *testTextLabel;

@property (strong,nonatomic) UILabel *testBarCodeLabel;

@property (strong,nonatomic) UILabel *testQRCodeLabel;

@property (strong,nonatomic) UILabel *testImageLabel;

@property (strong,nonatomic) UILabel *testExample;

@property (assign,nonatomic) CGFloat SCREEN_W;

@property (assign,nonatomic) CGFloat SCREEN_H;


@end

@implementation ViewController

- (void)viewDidLoad {
    _SCREEN_W = [UIScreen mainScreen].bounds.size.width;
    _SCREEN_H = [UIScreen mainScreen].bounds.size.height;
    
    [super viewDidLoad];
    [self initView];
    [self addGesture];
}

- (void)viewWillAppear:(BOOL)animated{
    BluetoothManager *bluetoothManager = [BluetoothManager bluetoothManagerInstance];
    self.blueNameUILabel.text = [bluetoothManager getCurrentName];
}


-(CGFloat)getRectNavAndStatusHight{
    return self.navigationController.navigationBar.frame.size.height+[[UIApplication sharedApplication] statusBarFrame].size.height;
}

-(void)addGesture{
    
    [self.blueNameUILabel setUserInteractionEnabled:true];
    UITapGestureRecognizer *blueNameTapGestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(gotoConnectBlueAction:)];
    [self.blueNameUILabel addGestureRecognizer:blueNameTapGestureRecognizer];
    
    [self.testImageLabel setUserInteractionEnabled:true];
    UITapGestureRecognizer *test58TapGestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(test58Action:)];
    [self.testImageLabel addGestureRecognizer:test58TapGestureRecognizer];
    
    [self.testTextLabel setUserInteractionEnabled:true];
    UITapGestureRecognizer *testTextLabelGestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(testTextAction:)];
    [self.testTextLabel addGestureRecognizer:testTextLabelGestureRecognizer];
    
    [self.testBarCodeLabel setUserInteractionEnabled:true];
    UITapGestureRecognizer *testBarCodeLabelGestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(testBarCodeAction:)];
    [self.testBarCodeLabel addGestureRecognizer:testBarCodeLabelGestureRecognizer];
    
    [self.testQRCodeLabel setUserInteractionEnabled:true];
    UITapGestureRecognizer * testQrCodeLabelGestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(testQRCodeAction:)];
    [self.testQRCodeLabel addGestureRecognizer:testQrCodeLabelGestureRecognizer];
    
    [self.testExample setUserInteractionEnabled:true];
    UITapGestureRecognizer *testExampleGestureRecognizer = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(testExampleAction:)];
    [self.testExample addGestureRecognizer:testExampleGestureRecognizer];
    
}

//打印文字
-(void)testTextAction:(UITapGestureRecognizer *)recognizer{
    BluetoothManager *blueToothManager = [BluetoothManager bluetoothManagerInstance];
    if(![blueToothManager isConnected]){
        NSLog(@"蓝牙未连接");
        [self gotoConnectBlueAction:NULL];
        return;
    }
    NSMutableData *instructionData = [[NSMutableData alloc] initWithCapacity:5];
    //清除画板缓存
    [instructionData appendData:[PrintfTSPLManager clearCanvas]];
    //初始化标签纸大小（标签宽和高，单位mm）
    [instructionData appendData:[PrintfTSPLManager initCanvas:60 height:30]];
    //打印方向设置（参数值为0和1，一正一反）
    [instructionData appendData:[PrintfTSPLManager setDirection:0]];
    //打印文字（参数说明，请看方法注释）
    [instructionData appendData:[PrintfTSPLManager printText:0 y:0 fontWidth:1 fontHeight:1 content:@"打印标签文字测试ABCDE"]];
    //开始打印（参数是打印的张数
    [instructionData appendData:[PrintfTSPLManager beginPrint:1]];
    //发送数据给打印机
    if([blueToothManager writeNSData:instructionData]){
        NSLog(@"正在打印...");
    }
}

//QRCODE指令解析：
//QRCODE x,y,ECC Level,cell width,mode,rotation,[model,mask,]"content"
-(void)testQRCodeAction:(UITapGestureRecognizer *)recognizer{
    BluetoothManager *blueToothManager = [BluetoothManager bluetoothManagerInstance];
    if(![blueToothManager isConnected]){
        NSLog(@"蓝牙未连接");
        [self gotoConnectBlueAction:NULL];
        return;
    }
    
    NSMutableData *instructionData = [[NSMutableData alloc] initWithCapacity:5];
    [instructionData appendData:[PrintfTSPLManager clearCanvas]];
    [instructionData appendData:[PrintfTSPLManager initCanvas:60 height:30]];
    [instructionData appendData:[PrintfTSPLManager setDirection:0]];
    [instructionData appendData:[PrintfTSPLManager printQRCode:0 y:0 level:@"H" width:1 rotation:0 content:@"测试的二维码的内容1"]];
    [instructionData appendData:[PrintfTSPLManager beginPrint:1]];
    if([blueToothManager writeNSData:instructionData]){
        NSLog(@"正在打印...");
    }
}

//打印条形码
-(void)testBarCodeAction:(UITapGestureRecognizer *)recognizer{
    BluetoothManager *blueToothManager = [BluetoothManager bluetoothManagerInstance];
    if(![blueToothManager isConnected]){
        NSLog(@"蓝牙未连接");
        [self gotoConnectBlueAction:NULL];
        return;
    }
    NSMutableData *instructionData = [[NSMutableData alloc] initWithCapacity:5];
    [instructionData appendData:[PrintfTSPLManager clearCanvas]];
    [instructionData appendData:[PrintfTSPLManager initCanvas:60 height:30]];
    [instructionData appendData:[PrintfTSPLManager setDirection:0]];
    [instructionData appendData:[PrintfTSPLManager printBarCode:0 y:0 codeType:@"128" height:48  narrow:4 barcodeTextAlign:2 rotation:0 content:@"11043001"]];
    [instructionData appendData:[PrintfTSPLManager beginPrint:1]];
    if([blueToothManager writeNSData:instructionData]){
        NSLog(@"正在打印...");
    }
}

//打印图片
-(void)test58Action:(UITapGestureRecognizer *)recognizer{
    BluetoothManager *blueToothManager = [BluetoothManager bluetoothManagerInstance];
    if(![blueToothManager isConnected]){
        NSLog(@"蓝牙未连接");
        [self gotoConnectBlueAction:NULL];
        return;
    }
    UIImage *uiImage = [UIImage imageNamed:@"p_one_six"];
    //更换图片的尺寸，发送的图片大小，不能大于标签纸大小，否则会打印不全，如果过大，需要重设图片大小
    uiImage = [self reSizeImage:uiImage toSize:CGSizeMake(40 * 8, 30 * 8)];
    NSMutableData *instructionData = [[NSMutableData alloc] initWithCapacity:5];
    NSData *clearCanvasNSData = [PrintfTSPLManager clearCanvas];
    NSData *initCanvasNSData = [PrintfTSPLManager initCanvas:40 height:30];
    [instructionData appendData:initCanvasNSData];
    [instructionData appendData:[PrintfTSPLManager setDirection:0]];
    [instructionData appendData:clearCanvasNSData];
    NSData *printImageData = [PrintfTSPLManager printImage:0 y:0 image:uiImage];
    [instructionData appendData:printImageData];
    NSData *printNSData = [PrintfTSPLManager beginPrint:1];
    [instructionData appendData:printNSData];
    if([blueToothManager writeNSData:instructionData]){
        return NSLog(@"正在打印...");
    }
}

//打印案例
-(void)testExampleAction:(UITapGestureRecognizer *)recognizer{
    BluetoothManager *blueToothManager = [BluetoothManager bluetoothManagerInstance];
    if(![blueToothManager isConnected]){
        NSLog(@"蓝牙未连接");
        [self gotoConnectBlueAction:NULL];
        return;
    }
    NSMutableData *instructionData = [[NSMutableData alloc] initWithCapacity:5];
    NSData *clearCanvasNSData = [PrintfTSPLManager clearCanvas];
    [instructionData appendData:clearCanvasNSData];
    NSData *initCanvasNSData = [PrintfTSPLManager initCanvas:60 height:30];
    [instructionData appendData:initCanvasNSData];
    [instructionData appendData:[PrintfTSPLManager setDirection:0]];
    [instructionData appendData:[PrintfTSPLManager printText:88 y:0 fontWidth:1 fontHeight:2 content:@"福建省食用农产品合格证（散户）"]];
    [instructionData appendData:[PrintfTSPLManager printText:0 y:50 fontWidth:1 fontHeight:1 content:@"我承诺"]];
    [instructionData appendData:[PrintfTSPLManager printText:0 y:80 fontWidth:1 fontHeight:1 content:@"没有食用禁用农药兽药"]];
    [instructionData appendData:[PrintfTSPLManager printBarCode:0 y:114 codeType:@"128" height:48  narrow:4 barcodeTextAlign:2 rotation:0 content:@"123456"]];
    NSData *printNSData = [PrintfTSPLManager beginPrint:1];
    [instructionData appendData:printNSData];
    if([blueToothManager writeNSData:instructionData]){
        return NSLog(@"正在打印...");
    }
}


//跳转到蓝牙列表，进行打印设备选择
-(void)gotoConnectBlueAction:(UITapGestureRecognizer *)recognizer{
    BluetoothController *controller = [[BluetoothController alloc] init];
    controller.modalPresentationStyle = UIModalPresentationFullScreen;
    [self presentViewController:controller animated:true completion:nil];
}

-(void)initView{
    
    self.view.backgroundColor = UIColor.whiteColor;
    
    CGFloat endY = [self getRectNavAndStatusHight] + 10;
    
    endY = [self initTestTextLabel:endY + 10];
    
    endY = [self initTestBarCodeLabel:endY + 10];
    
    endY = [self initTestQRCodeLabel:endY + 10];
    
    endY = [self initTestImageLabel:endY + 10];
    
    endY = [self initTestExample:endY + 10];
    
    endY = [self initBlueNameLabel:endY];
    
}

-(CGFloat)initTestQRCodeLabel:(CGFloat)startY{
    self.testQRCodeLabel = [[UILabel alloc] init];
    self.testQRCodeLabel.text = @"测试二维码";
    self.testQRCodeLabel.frame = CGRectMake(10, startY, _SCREEN_W - 20, 50);
    self.testQRCodeLabel.backgroundColor = UIColor.grayColor;
    self.testQRCodeLabel.textColor = UIColor.whiteColor;
    self.testQRCodeLabel.textAlignment = NSTextAlignmentCenter;
    self.testQRCodeLabel.layer.cornerRadius = 10;
    self.testQRCodeLabel.layer.masksToBounds = true;
    [self.view addSubview:self.testQRCodeLabel];
    return self.testQRCodeLabel.frame.origin.y + self.testQRCodeLabel.frame.size.height;
}


-(CGFloat)initTestBarCodeLabel:(CGFloat)startY{
    self.testBarCodeLabel = [[UILabel alloc] init];
    self.testBarCodeLabel.text = @"测试条码";
    self.testBarCodeLabel.frame = CGRectMake(10, startY, _SCREEN_W - 20, 50);
    self.testBarCodeLabel.backgroundColor = UIColor.grayColor;
    self.testBarCodeLabel.textColor = UIColor.whiteColor;
    self.testBarCodeLabel.textAlignment = NSTextAlignmentCenter;
    self.testBarCodeLabel.layer.cornerRadius = 10;
    self.testBarCodeLabel.layer.masksToBounds = true;
    [self.view addSubview:self.testBarCodeLabel];
    return self.testBarCodeLabel.frame.origin.y + self.testBarCodeLabel.frame.size.height;
}

-(CGFloat)initTestTextLabel:(CGFloat)startY{
    self.testTextLabel = [[UILabel alloc] init];
    self.testTextLabel.text = @"测试文字";
    self.testTextLabel.frame = CGRectMake(10, startY, _SCREEN_W - 20, 50);
    self.testTextLabel.backgroundColor = UIColor.grayColor;
    self.testTextLabel.textColor = UIColor.whiteColor;
    self.testTextLabel.textAlignment = NSTextAlignmentCenter;
    self.testTextLabel.layer.cornerRadius = 10;
    self.testTextLabel.layer.masksToBounds = true;
    [self.view addSubview:self.testTextLabel];
    return self.testTextLabel.frame.origin.y + self.testTextLabel.frame.size.height;
}

/**
 * 打印图片
 */
-(CGFloat)initTestImageLabel:(CGFloat)startY{
    self.testImageLabel = [[UILabel alloc] init];
    self.testImageLabel.text = @"打印图片40*30";
    self.testImageLabel.frame = CGRectMake(10, startY, _SCREEN_W - 20, 50);
    self.testImageLabel.backgroundColor = UIColor.grayColor;
    self.testImageLabel.textColor = UIColor.whiteColor;
    self.testImageLabel.textAlignment = NSTextAlignmentCenter;
    self.testImageLabel.layer.cornerRadius = 10;
    self.testImageLabel.layer.masksToBounds = true;
    [self.view addSubview:self.testImageLabel];
    return self.testImageLabel.frame.origin.y + self.testImageLabel.frame.size.height;
}

/**
 * 打印案例
 */
-(CGFloat)initTestExample:(CGFloat)startY{
    self.testExample = [[UILabel alloc] init];
    self.testExample.text = @"打印案例";
    self.testExample.frame = CGRectMake(10, startY, _SCREEN_W - 20, 50);
    self.testExample.backgroundColor = UIColor.grayColor;
    self.testExample.textColor = UIColor.whiteColor;
    self.testExample.textAlignment = NSTextAlignmentCenter;
    self.testExample.layer.cornerRadius = 10;
    self.testExample.layer.masksToBounds = true;
    [self.view addSubview:self.testExample];
    return self.testExample.frame.origin.y + self.testExample.frame.size.height;
}


-(CGFloat)initBlueNameLabel:(CGFloat)startY{
    self.blueNameUILabel = [[UILabel alloc] init];
    self.blueNameUILabel.text = @"未连接蓝牙";
    self.blueNameUILabel.frame = CGRectMake(10, startY, _SCREEN_W - 20, 50);
    self.blueNameUILabel.textAlignment = NSTextAlignmentRight;
    [self.view addSubview:self.blueNameUILabel];
    return self.blueNameUILabel.frame.origin.y + self.blueNameUILabel.frame.size.height;
}

/**
 * 改变图片的尺寸
 */
-(UIImage *)reSizeImage:(UIImage *)image toSize:(CGSize)reSize{
    UIGraphicsBeginImageContext(CGSizeMake(reSize.width, reSize.height));
    [image drawInRect:CGRectMake(0, 0, reSize.width, reSize.height)];
    UIImage *reSizeImage = UIGraphicsGetImageFromCurrentImageContext();
    UIGraphicsEndImageContext();
    return reSizeImage;
}

@end
