//
//  PrintfTSPLManager.m
//  DemoLabel
//
//  Created by Mac on 12/28/20.
//  Copyright © 2020 label printf demo. All rights reserved.
//

#import "PrintfTSPLManager.h"

@implementation PrintfTSPLManager

+ (NSData *)initCanvas:(int)width height:(int)height{
    NSMutableString *instructionNSString = [[NSMutableString alloc] initWithCapacity:5];
    [instructionNSString appendString:@"SIZE "];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d",width]];
    [instructionNSString appendString:@" mm,"];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d",height]];
    [instructionNSString appendString:@" mm\r\n"];
    return [self textToGBKNSData:instructionNSString];
}

+ (NSData *)setDirection:(int)direction{
    return [self textToGBKNSData:[NSString stringWithFormat:@"DIRECTION %d\r\n", direction]];
}

+(NSData *)clearCanvas{
    NSString *text = @"CLS\r\n";
    return [self textToGBKNSData:text];
}

+(NSData *)printText:(int)x y:(int)y fontWidth:(int)fontWidth fontHeight:(int)fontHeight content:(NSString *)content{
    NSMutableString *instructionNSString = [[NSMutableString alloc] initWithCapacity:3];
    [instructionNSString appendString:@"TEXT "];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",x]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",y]];
    [instructionNSString appendString:@"\"TSS24.BF2\",0,"];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",fontWidth]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",fontHeight]];
    [instructionNSString appendString:[NSString stringWithFormat:@"\"%@\"\r\n",content]];
    return [self textToGBKNSData:instructionNSString];
}

+(NSData *)printBarCode:(int)x y:(int)y codeType:(NSString *)barCodeType height:(int)height barcodeTextAlign:(int)textAlign rotation:(int)rotation content:(NSString *)content{
    NSMutableString *instructionNSString = [[NSMutableString alloc] initWithCapacity:3];
    [instructionNSString appendString:@"BARCODE "];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",x]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",y]];
    [instructionNSString appendString:[NSString stringWithFormat:@"\"%@\",",barCodeType]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",height]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",textAlign]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",rotation]];
    [instructionNSString appendString:[NSString stringWithFormat:@"2,4,"]];
    [instructionNSString appendString:[NSString stringWithFormat:@"\"%@\"\r\n",content]];
    return [self textToGBKNSData:instructionNSString];
}

+(NSData *)printQRCode:(int)x y:(int)y level:(NSString *)level width:(int)width rotation:(int)rotation content:(NSString *)content{
    NSMutableString *instructionNSString = [[NSMutableString alloc] initWithCapacity:3];
    [instructionNSString appendString:@"QRCODE "];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",x]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",y]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%@,",level]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",width]];
    [instructionNSString appendString:[NSString stringWithFormat:@"M1,"]];
    [instructionNSString appendString:[NSString stringWithFormat:@"%d,",rotation]];
    [instructionNSString appendString:[NSString stringWithFormat:@"M1,S1,"]];
    [instructionNSString appendString:[NSString stringWithFormat:@"\"%@\"\r\n",content]];
    return [self textToGBKNSData:instructionNSString];
}

+(NSData *)printImage:(int)x y:(int)y image:(UIImage *)image;{
    
    NSString *instruction = [NSString stringWithFormat: @"BITMAP %i,%i,%f,%f,1,",x,y,image.size.width / 8,image.size.height];
    NSMutableData *nsData = [[NSMutableData alloc] initWithCapacity:5];
    [nsData appendData:[self textToGBKNSData:instruction]];
    NSData *uiimageNSData = [self covertToGrayScaleWithImage:image];
    [nsData appendData:uiimageNSData];
    [nsData appendData:[self textToGBKNSData:@"\r\n"]];
    return nsData;
}

+ (NSData *)beginPrint:(int)number{
    NSString *instruction = [NSString stringWithFormat:@"PRINT 1,%i\r\n",number];
    return [self textToGBKNSData:instruction];
}


+ (NSData *)textToGBKNSData:(NSString *)text{
    NSData *data = [text dataUsingEncoding:CFStringConvertEncodingToNSStringEncoding(kCFStringEncodingGB_18030_2000)];
    return data;
}


/**
 * 图片的二值化
 */
+ (NSData *)covertToGrayScaleWithImage:(UIImage *)image{
    int width =image.size.width;
    int height =image.size.height;
    //像素将画在这个数组
    uint32_t *pixels = (uint32_t *)malloc(width *height *sizeof(uint32_t));
    //清空像素数组
    memset(pixels, 0, width*height*sizeof(uint32_t));
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();
    
    //用 pixels 创建一个 context
    CGContextRef context = CGBitmapContextCreate(pixels, width, height, 8, width*sizeof(uint32_t), colorSpace, kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedLast);
    CGContextDrawImage(context, CGRectMake(0, 0, width, height), image.CGImage);
    
    int tt =1;
    int bw = 0;
    Byte bytes[width / 8 * height];
    int p[8]={0,0,0,0,0,0,0,0};
    for (int y = 0; y <height; y++) {
        for (int x =0; x <width/8; x ++) {
            for(int z = 0; z < 8; z++){
                uint8_t *rgbaPixel = (uint8_t *)&pixels[(y*width)+(x* 8+z)];
                int red = rgbaPixel[tt];
                int green = rgbaPixel[tt + 1];
                int blue = rgbaPixel[tt + 2];
                int gray = 0.29900 * red + 0.58700 * green + 0.11400 * blue; // 灰度转化公式
                if (gray <= 128) {
                    gray = 0;
                } else {
                    gray = 1;
                }
                p[z] = gray;
            }
            int value = (p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7]);
            bytes[bw] = value;
            bw++;
        }
    }
    free(pixels);
    NSData *data = [NSData dataWithBytes: bytes length: sizeof(bytes)];
    return data;
}
@end
