/*
 * Decompiled with CFR 0.152.
 */
package com.mht.print.sdk.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.mht.print.sdk.IPrinterPort;
import com.mht.print.sdk.util.Utils;
import java.nio.ByteBuffer;

public class USBPort
implements IPrinterPort {
    private String TAG = USBPort.class.getSimpleName();
    private UsbManager mUsbManager;
    private UsbDevice mUsbDevice;
    private UsbDeviceConnection connection;
    private UsbInterface usbInterface;
    private UsbEndpoint inEndpoint;
    private UsbEndpoint outEndpoint;
    private boolean isOldUSB;
    private Handler mHandler;
    private int connectState;
    private int printerState;
    private final Context mContext;
    private byte[] cacheReadBytes;
    private String productName = null;
    private static final String ACTION_USB_PERMISSION = "com.android.usb.USB_PERMISSION";
    private ConnectThread mConnectThread;
    static final int MAX_USBFS_BUFFER_SIZE = 16384;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (USBPort.ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    USBPort.this.mContext.unregisterReceiver(USBPort.this.mUsbReceiver);
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false) && USBPort.this.mUsbDevice.equals((Object)device)) {
                        USBPort.this.connect();
                    } else {
                        USBPort.this.setConnectState(102);
                        Log.e((String)USBPort.this.TAG, (String)("permission denied for device " + device));
                    }
                }
            }
        }
    };

    public USBPort(Context context, UsbDevice usbDevice, Handler handler) {
        this.mContext = context;
        this.mUsbManager = (UsbManager)this.mContext.getSystemService("usb");
        this.mUsbDevice = usbDevice;
        this.mHandler = handler;
        this.connectState = 103;
        this.printerState = 105;
        this.setProductName();
        Utils.Log(this.TAG, "init\n");
    }

    @Override
    public void open() {
        Utils.Log(this.TAG, "open\n");
        if (this.connectState != 103) {
            this.close();
        }
        if (USBPort.isUsbPrinter(this.mUsbDevice)) {
            if (this.mUsbManager.hasPermission(this.mUsbDevice)) {
                this.connect();
            } else {
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
                IntentFilter filter = new IntentFilter(ACTION_USB_PERMISSION);
                this.mContext.registerReceiver(this.mUsbReceiver, filter);
                this.mUsbManager.requestPermission(this.mUsbDevice, pendingIntent);
            }
        } else {
            this.setConnectState(102);
        }
    }

    private void connect() {
        Utils.Log(this.TAG, "start connect\n");
        this.mConnectThread = new ConnectThread();
        this.mConnectThread.start();
    }

    private void setProductName() {
        if (this.mUsbDevice != null && Build.VERSION.SDK_INT >= 21) {
            String productName;
            this.productName = productName = this.mUsbDevice.getProductName();
            this.TAG = productName;
            Utils.Log(this.TAG, "productName\uff1a" + productName + "\n");
        }
    }

    @Override
    public void close() {
        Utils.Log(this.TAG, "start close\n");
        if (this.connection != null) {
            this.connection.releaseInterface(this.usbInterface);
            this.connection.close();
            this.connection = null;
            Utils.Log(this.TAG, "close success\n");
        }
        this.mConnectThread = null;
        this.setPrinterState(105);
        if (this.connectState != 102) {
            this.setConnectState(103);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(byte[] bytes) {
        Utils.Log(this.TAG, "start write length is:" + bytes.length + "\n");
        USBPort uSBPort = this;
        synchronized (uSBPort) {
            if (this.connection == null) {
                return -1;
            }
            int subpackage = bytes.length % 16384 == 0 ? bytes.length / 16384 : bytes.length / 16384 + 1;
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            int successSentBytes = 0;
            for (int i = 0; i < subpackage; ++i) {
                byte[] newByte = i + 1 == subpackage ? new byte[bytes.length - (subpackage - 1) * 16384] : new byte[16384];
                byteBuffer.get(newByte, 0, newByte.length);
                int transferredLength = this.connection.bulkTransfer(this.outEndpoint, newByte, newByte.length, 3000);
                Utils.Log(this.TAG, "write transferredLength:" + transferredLength + "\n");
                successSentBytes += Math.max(transferredLength, 0);
            }
            return successSentBytes == 0 ? -1 : successSentBytes;
        }
    }

    @Override
    public byte[] read() {
        return this.read(2000);
    }

    private byte[] read(int timeout) {
        byte[] retData;
        int readLen;
        Utils.Log(this.TAG, "start read timeout:" + timeout + "\n");
        if (this.connection != null && (readLen = this.connection.bulkTransfer(this.inEndpoint, retData = new byte[64], retData.length, timeout)) > 0) {
            if (readLen == 64) {
                return retData;
            }
            byte[] realData = new byte[readLen];
            System.arraycopy(retData, 0, realData, 0, readLen);
            return realData;
        }
        Utils.Log(this.TAG, "read end data is null\n");
        return null;
    }

    public boolean isOldUSB() {
        return this.isOldUSB;
    }

    public static boolean isUsbPrinter(UsbDevice device) {
        int vendorId = device.getVendorId();
        int productId = device.getProductId();
        return 1152 == vendorId && 22304 == productId || 1155 == vendorId && 22304 == productId || 4070 == vendorId && 33054 == productId || 10473 == vendorId && 645 == productId;
    }

    private synchronized void setConnectState(int state) {
        if (this.connectState != state) {
            this.connectState = state;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.connectState).sendToTarget();
            }
        }
    }

    private synchronized void setPrinterState(int state) {
        if (this.printerState != state) {
            this.printerState = state;
        }
    }

    @Override
    public int getConnectState() {
        return this.connectState;
    }

    @Override
    public int getPrinterState() {
        if ("MHT-L58G".equals(this.productName)) {
            return this.printerState;
        }
        return this.getNewPrinterState();
    }

    public int getOldPrinterState() {
        try {
            int oldPrintStatus = this.printerState;
            Utils.Log(this.TAG, "oldPrintStatus:" + oldPrintStatus + "\n");
            if (oldPrintStatus == 107 || oldPrintStatus == 105) {
                int i = 0;
                while (i < 30) {
                    if (oldPrintStatus != this.printerState) {
                        Utils.Log(this.TAG, "printerState change new printer status is :" + this.printerState + "\n");
                        return this.printerState;
                    }
                    Utils.Log(this.TAG, "get printer status loop i:" + ++i + "\n");
                    Thread.sleep(50L);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Utils.Log(this.TAG, "return printerState:" + this.printerState + "\n");
        return this.printerState;
    }

    public int getNewPrinterState() {
        try {
            byte[] readData;
            byte[] oldData = this.read(100);
            Utils.Log(this.TAG, "getPrinterStatus\uff0cread oldData:" + Utils.bytesToHexString(oldData) + "\n");
            int writeLength = this.write(new byte[]{16, 4, 2, 16, 4, 3, 16, 4, 4});
            if (writeLength != -1 && (readData = this.read(100)) != null) {
                String hexString = Utils.bytesToHexString(readData);
                Utils.Log(this.TAG, "getPrinterStatus\uff0cprinter return:" + hexString + "\n");
                switch (hexString) {
                    case "201612": 
                    case "201212": 
                    case "201252": 
                    case "32": {
                        return 108;
                    }
                    case "001212": 
                    case "12": {
                        return 107;
                    }
                    case "001612": {
                        return 106;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Utils.Log(this.TAG, "getPrinterStatus\uff0cquery fail\n");
        return 105;
    }

    private void startThreadToReadData() {
        Utils.Log(this.TAG, "startThreadToReadData\n");
        this.cacheReadBytes = new byte[1024];
        new Thread(() -> {
            while (this.inEndpoint != null && this.connection != null) {
                this.readPacketData();
            }
        }).start();
    }

    private void readPacketData() {
        try {
            if (this.connection == null) {
                return;
            }
            int readLength = this.connection.bulkTransfer(this.inEndpoint, this.cacheReadBytes, this.cacheReadBytes.length, 100);
            if (readLength > 0) {
                byte[] readBytes = new byte[readLength];
                System.arraycopy(this.cacheReadBytes, 0, readBytes, 0, readLength);
                String bytesToHexString = Utils.bytesToHexString(readBytes);
                Utils.Log(this.TAG, "readPacketData\uff1a" + bytesToHexString + "\n");
                int length = bytesToHexString.length();
                if (length >= 6) {
                    bytesToHexString = bytesToHexString.substring(length - 4, length);
                }
                switch (bytesToHexString) {
                    case "00": 
                    case "1E": 
                    case "32": 
                    case "72": 
                    case "1252": 
                    case "1652": {
                        this.setPrinterState(108);
                        break;
                    }
                    case "01": 
                    case "12": 
                    case "1212": {
                        this.setPrinterState(107);
                        break;
                    }
                    case "02": 
                    case "03": 
                    case "36": 
                    case "1612": {
                        this.setPrinterState(106);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class ConnectThread
    extends Thread {
        private ConnectThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean hasError = true;
            if (USBPort.this.mUsbManager.hasPermission(USBPort.this.mUsbDevice)) {
                USBPort.this.isOldUSB = 1659 == USBPort.this.mUsbDevice.getVendorId() && 8965 == USBPort.this.mUsbDevice.getProductId();
                try {
                    USBPort.this.usbInterface = USBPort.this.mUsbDevice.getInterface(0);
                    for (int i = 0; i < USBPort.this.usbInterface.getEndpointCount(); ++i) {
                        UsbEndpoint ep = USBPort.this.usbInterface.getEndpoint(i);
                        if (ep.getType() != 2) continue;
                        if (ep.getDirection() == 0) {
                            USBPort.this.outEndpoint = ep;
                            continue;
                        }
                        if (ep.getDirection() != 128) continue;
                        USBPort.this.inEndpoint = ep;
                    }
                    if (USBPort.this.inEndpoint == null) {
                        USBPort.this.inEndpoint = USBPort.this.usbInterface.getEndpoint(0);
                    }
                    USBPort.this.connection = USBPort.this.mUsbManager.openDevice(USBPort.this.mUsbDevice);
                    if (USBPort.this.connection != null && USBPort.this.connection.claimInterface(USBPort.this.usbInterface, true)) {
                        hasError = false;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ConnectThread e = this;
            synchronized (e) {
                USBPort.this.mConnectThread = null;
            }
            if (hasError) {
                Utils.Log(USBPort.this.TAG, "connect failed\n");
                USBPort.this.setConnectState(102);
                USBPort.this.close();
            } else {
                Utils.Log(USBPort.this.TAG, "connect success\n");
                USBPort.this.setConnectState(101);
                if ("MHT-L58G".equals(USBPort.this.productName)) {
                    try {
                        USBPort.this.startThreadToReadData();
                        if (USBPort.this.connection != null) {
                            Utils.Log(USBPort.this.TAG, "start send command to get printer status\n");
                            USBPort.this.write(new byte[]{16, 4, 2, 16, 4, 3, 16, 4, 4});
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
    }
}

