/*
 * Decompiled with CFR 0.152.
 */
package com.mht.print.sdk.wifi;

import android.os.Handler;
import com.mht.print.sdk.IPrinterPort;
import com.mht.print.sdk.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class WiFiPort
implements IPrinterPort {
    private static String TAG = "WifiPrinter";
    private String address;
    private int port;
    private Socket mSocket;
    private OutputStream outputStream;
    private InputStream inputStream;
    private ConnectThread mConnectThread;
    private Handler mHandler;
    private int connectState;
    private int printerState;
    private int readLen;

    public WiFiPort(String ipAddress, int portNumber, Handler handler) {
        this.address = ipAddress;
        this.port = portNumber;
        this.mHandler = handler;
        this.connectState = 103;
        this.printerState = 105;
    }

    @Override
    public void open() {
        Utils.Log(TAG, "open connect to: " + this.address);
        if (this.connectState != 103) {
            this.close();
        }
        this.mConnectThread = new ConnectThread();
        this.mConnectThread.start();
    }

    @Override
    public void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.outputStream = null;
        this.inputStream = null;
        this.mSocket = null;
        this.mConnectThread = null;
        this.setPrinterState(105);
        if (this.connectState != 102) {
            this.setConnectState(103);
        }
    }

    @Override
    public int getPrinterState() {
        try {
            byte[] oldData = this.read();
            Utils.Log(TAG, "getPrinterStatus\uff0cread oldData:" + Utils.bytesToHexString(oldData) + "\n");
            int writeLength = this.write(new byte[]{16, 4, 2, 16, 4, 3, 16, 4, 4});
            if (writeLength != -1) {
                int i = 0;
                while (i < 4) {
                    Thread.sleep(200L);
                    byte[] readData = this.read();
                    if (readData != null) {
                        String hexString = Utils.bytesToHexString(readData);
                        Utils.Log(TAG, "getPrinterStatus\uff0cprinter return:" + hexString + "\n");
                        switch (hexString) {
                            case "201612": 
                            case "201212": 
                            case "201252": 
                            case "32": {
                                return 108;
                            }
                            case "001212": 
                            case "12": {
                                return 107;
                            }
                            case "001612": {
                                return 106;
                            }
                        }
                    }
                    Utils.Log(TAG, "getPrinterStatus\uff0cnext loop read\uff1a" + ++i + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Utils.Log(TAG, "getPrinterStatus\uff0cquery fail\n");
        return 105;
    }

    @Override
    public int write(byte[] bytes) {
        try {
            Utils.Log(TAG, "start write length is:" + bytes.length + "\n");
            if (this.outputStream != null) {
                int length = bytes.length;
                int subpackage = 1024;
                int byteIntegerLength = length / subpackage;
                int byteRemainderLength = length % subpackage;
                for (int i = 0; i < byteIntegerLength; ++i) {
                    byte[] bytes1 = new byte[subpackage];
                    System.arraycopy(bytes, i * subpackage, bytes1, 0, subpackage);
                    this.outputStream.write(bytes1);
                }
                byte[] bytes2 = new byte[byteRemainderLength];
                System.arraycopy(bytes, byteIntegerLength * subpackage, bytes2, 0, bytes2.length);
                this.outputStream.write(bytes2);
                Utils.Log(TAG, "write transferredLength:" + bytes2.length + "\n");
                return 0;
            }
            Utils.Log(TAG, "write transferredLength:-1\n");
            return -1;
        }
        catch (IOException e) {
            e.printStackTrace();
            Utils.Log(TAG, "write transferredLength:-1\n");
            return -1;
        }
    }

    @Override
    public byte[] read() {
        byte[] readBuff = null;
        try {
            if (this.inputStream != null && (this.readLen = this.inputStream.available()) > 0) {
                readBuff = new byte[this.readLen];
                int read = this.inputStream.read(readBuff);
                Utils.Log(TAG, "read length:" + read);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return readBuff;
    }

    private synchronized void setConnectState(int state) {
        Utils.Log(TAG, "setConnectState() " + this.connectState + " -> " + state);
        if (this.connectState != state) {
            this.connectState = state;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.connectState).sendToTarget();
            }
        }
    }

    private synchronized void setPrinterState(int state) {
        Utils.Log(TAG, "setPrinterState() " + this.printerState + " -> " + state);
        if (this.printerState != state) {
            this.printerState = state;
        }
    }

    @Override
    public int getConnectState() {
        return this.connectState;
    }

    public Boolean isServerClose() {
        try {
            this.mSocket.sendUrgentData(255);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    private class ConnectThread
    extends Thread {
        private ConnectThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean hasError = true;
            InetSocketAddress mSocketAddress = new InetSocketAddress(WiFiPort.this.address, WiFiPort.this.port);
            try {
                WiFiPort.this.mSocket = new Socket();
                WiFiPort.this.mSocket.setSoTimeout(3000);
                WiFiPort.this.mSocket.connect(mSocketAddress, 5000);
                WiFiPort.this.outputStream = WiFiPort.this.mSocket.getOutputStream();
                WiFiPort.this.inputStream = WiFiPort.this.mSocket.getInputStream();
                hasError = false;
            }
            catch (SocketException e) {
                Utils.Log(TAG, "socketException connect failed\n");
                Utils.Log(TAG, e.getMessage());
                e.printStackTrace();
            }
            catch (IOException e) {
                Utils.Log(TAG, "connect failed\n");
                Utils.Log(TAG, e.getMessage());
                e.printStackTrace();
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                WiFiPort.this.mConnectThread = null;
            }
            if (hasError) {
                WiFiPort.this.setConnectState(102);
                WiFiPort.this.close();
            } else {
                WiFiPort.this.setConnectState(101);
            }
        }
    }
}

