/*
 * Decompiled with CFR 0.152.
 */
package com.mht.print.sdk.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Environment;
import android.util.Log;
import com.mht.print.sdk.PrinterInstance;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;

public class Utils {
    public static final String TAG = Utils.class.getSimpleName();
    public static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public static String bytesToHexString(byte[] bArray) {
        if (bArray == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder(bArray.length);
        for (byte b : bArray) {
            String sTemp = Integer.toHexString(0xFF & b);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static final byte[] hex2byte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            int byteint = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = Integer.valueOf(byteint).byteValue();
            ++i;
            ++j;
        }
        return b;
    }

    public static Bitmap compressBitmap(Bitmap srcBitmap, int maxLength) {
        Bitmap destBitmap = null;
        try {
            int destHeight1;
            int destWidth1;
            double ratio;
            BitmapFactory.Options opts = new BitmapFactory.Options();
            byte[] srcBytes = Utils.bitmap2Bytes(srcBitmap);
            BitmapFactory.decodeByteArray((byte[])srcBytes, (int)0, (int)srcBytes.length, (BitmapFactory.Options)opts);
            int srcWidth = opts.outWidth;
            int srcHeight = opts.outHeight;
            boolean destWidth = false;
            boolean destHeight = false;
            if (srcWidth > srcHeight) {
                ratio = srcWidth / maxLength;
                destWidth1 = maxLength;
                destHeight1 = (int)((double)srcHeight / ratio);
            } else {
                ratio = srcHeight / maxLength;
                destHeight1 = maxLength;
                destWidth1 = (int)((double)srcWidth / ratio);
            }
            BitmapFactory.Options newOpts = new BitmapFactory.Options();
            newOpts.inSampleSize = (int)ratio + 1;
            newOpts.inJustDecodeBounds = false;
            newOpts.outHeight = destHeight1;
            newOpts.outWidth = destWidth1;
            destBitmap = BitmapFactory.decodeByteArray((byte[])srcBytes, (int)0, (int)srcBytes.length, (BitmapFactory.Options)newOpts);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return destBitmap;
    }

    public static byte[] readStream(InputStream inStream) throws Exception {
        int len1;
        byte[] buffer = new byte[1024];
        boolean len = true;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        while ((len1 = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, len1);
        }
        byte[] data = outStream.toByteArray();
        outStream.close();
        inStream.close();
        return data;
    }

    public static Bitmap getImageFromBytes(byte[] bytes, BitmapFactory.Options opts) {
        return bytes != null ? (opts != null ? BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)opts) : BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length)) : null;
    }

    public static Bitmap handleBitmap(Bitmap bitmap, float newBitmapW, float newBitmapH) {
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        float scaleWidth = newBitmapW / (float)width;
        float scaleHeight = newBitmapH / (float)height;
        Matrix matrix = new Matrix();
        matrix.postScale(scaleWidth, scaleHeight);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        return bitmap;
    }

    public static byte[] bitmap2Bytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveFileFromBytes(byte[] b, String outputFile) {
        FilterOutputStream stream = null;
        File file = null;
        try {
            file = new File(outputFile);
            FileOutputStream e = new FileOutputStream(file);
            stream = new BufferedOutputStream(e);
            stream.write(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public static int printBitmap2File(Bitmap bitmap, String filePath) {
        File file = filePath.endsWith(".png") ? new File(filePath) : new File(filePath + ".png");
        try {
            FileOutputStream e = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)e);
            e.close();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static byte[] bitmap2PrinterBytes(Bitmap bitmap, int left) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        byte[] imgbuf = new byte[(width / 8 + left + 4) * height];
        byte[] bitbuf = new byte[width / 8];
        int[] p = new int[8];
        int s = 0;
        Utils.Log(TAG, "+++++++++++++++ Total Bytes: " + (width / 8 + 4) * height);
        for (int y = 0; y < height; ++y) {
            int n;
            for (n = 0; n < width / 8; ++n) {
                int value;
                for (value = 0; value < 8; ++value) {
                    int blue;
                    int green;
                    int grey = bitmap.getPixel(n * 8 + value, y);
                    int red = (grey & 0xFF0000) >> 16;
                    int gray = (int)(0.299 * (double)red + 0.587 * (double)(green = (grey & 0xFF00) >> 8) + 0.114 * (double)(blue = grey & 0xFF));
                    gray = gray <= 190 ? 1 : 0;
                    p[value] = gray;
                }
                value = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                bitbuf[n] = (byte)value;
            }
            if (y != 0) {
                imgbuf[++s] = 22;
            } else {
                imgbuf[s] = 22;
            }
            imgbuf[++s] = (byte)(width / 8 + left);
            for (n = 0; n < left; ++n) {
                imgbuf[++s] = 0;
            }
            for (n = 0; n < width / 8; ++n) {
                imgbuf[++s] = bitbuf[n];
            }
            imgbuf[++s] = 21;
            imgbuf[++s] = 1;
        }
        return imgbuf;
    }

    public static byte[] escBitmapPrint(Bitmap bitmap) {
        bitmap = Utils.convertGreyImgByFloyd(bitmap);
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int horizontalBytes = width % 8 != 0 ? width / 8 + 1 : width / 8;
        byte[] command1 = new byte[]{29, 118, 48, 0, (byte)(horizontalBytes % 256), (byte)(horizontalBytes / 256), (byte)(height % 256), (byte)(height / 256)};
        byte[] bytes = new byte[horizontalBytes * height];
        int index = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < horizontalBytes; ++j) {
                byte value = 0;
                for (int k = 0; k < 8; ++k) {
                    int pixel;
                    if (j * 8 + k >= width || (pixel = bitmap.getPixel(j * 8 + k, i)) == -1 || pixel == 0) continue;
                    value = (byte)(value | (byte)(128 >> k));
                }
                bytes[index++] = value;
            }
        }
        byte[] bytes1 = new byte[command1.length + bytes.length];
        System.arraycopy(command1, 0, bytes1, 0, command1.length);
        System.arraycopy(bytes, 0, bytes1, command1.length, bytes.length);
        return bytes1;
    }

    public static Bitmap convertGreyImgByFloyd(Bitmap bitmap) {
        int j;
        int i;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] gray = new int[height * width];
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                int red;
                int grey = pixels[width * i + j];
                gray[width * i + j] = red = (grey & 0xFF0000) >> 16;
            }
        }
        for (i = 0; i < height; ++i) {
            for (j = 0; j < width; ++j) {
                int e;
                int g = gray[width * i + j];
                if (g >= 128) {
                    pixels[width * i + j] = -1;
                    e = g - 255;
                } else {
                    pixels[width * i + j] = -16777216;
                    e = g;
                }
                if (j < width - 1 && i < height - 1) {
                    int n = width * i + j + 1;
                    gray[n] = gray[n] + 3 * e / 8;
                    int n2 = width * (i + 1) + j;
                    gray[n2] = gray[n2] + 3 * e / 8;
                    int n3 = width * (i + 1) + j + 1;
                    gray[n3] = gray[n3] + e / 4;
                    continue;
                }
                if (j == width - 1 && i < height - 1) {
                    int n = width * (i + 1) + j;
                    gray[n] = gray[n] + 3 * e / 8;
                    continue;
                }
                if (j >= width - 1 || i != height - 1) continue;
                int n = width * i + j + 1;
                gray[n] = gray[n] + e / 4;
            }
        }
        Bitmap newBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        newBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return newBitmap;
    }

    public static byte[] bitmap2PrinterBytes_stylus(Bitmap bitmap, int multiple, int left) {
        int i;
        int sb;
        byte[] imgBuf;
        int height = bitmap.getHeight();
        int width = bitmap.getWidth() + left;
        boolean need_0a = false;
        int maxWidth = 240;
        if (width < maxWidth) {
            imgBuf = new byte[(height / 8 + 1) * (width + 6)];
            need_0a = true;
        } else {
            imgBuf = new byte[(height / 8 + 1) * (width + 5) + 2];
        }
        byte[] tmpBuf = new byte[width + 5];
        int[] p = new int[8];
        int s = 0;
        boolean t = false;
        boolean allZERO = true;
        for (sb = 0; sb < height / 8 + 1; ++sb) {
            int temp;
            int b = 0;
            tmpBuf[b] = 27;
            int i1 = b + 1;
            tmpBuf[i1] = 42;
            tmpBuf[++i1] = (byte)multiple;
            tmpBuf[++i1] = (byte)(width % maxWidth);
            tmpBuf[++i1] = (byte)(width / maxWidth > 0 ? 1 : 0);
            allZERO = true;
            for (temp = 0; temp < width; ++temp) {
                for (i = 0; i < 8; ++i) {
                    p[i] = sb * 8 + i < height && temp >= left ? (bitmap.getPixel(temp - left, sb * 8 + i) == -1 ? 0 : 1) : 0;
                }
                i = p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7];
                tmpBuf[++i1] = (byte)i;
                if (i == 0) continue;
                allZERO = false;
            }
            if (allZERO) {
                if (s == 0) {
                    imgBuf[s] = 27;
                } else {
                    imgBuf[++s] = 27;
                }
                imgBuf[++s] = 74;
                imgBuf[++s] = 8;
                continue;
            }
            for (temp = 0; temp < i1 + 1; ++temp) {
                if (temp == 0 && s == 0) {
                    imgBuf[s] = tmpBuf[temp];
                    continue;
                }
                imgBuf[++s] = tmpBuf[temp];
            }
            if (!need_0a) continue;
            imgBuf[++s] = 10;
        }
        if (!need_0a) {
            imgBuf[++s] = 13;
            imgBuf[++s] = 10;
        }
        byte[] realBuf = new byte[s + 1];
        for (sb = 0; sb < s + 1; ++sb) {
            realBuf[sb] = imgBuf[sb];
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (i = 0; i < realBuf.length; ++i) {
            String toHexString = Integer.toHexString(realBuf[i] & 0xFF);
            if (toHexString.length() == 1) {
                toHexString = "0" + toHexString;
            }
            stringBuffer.append(toHexString).append(" ");
            if ((i == 0 || i % 100 != 0) && i != realBuf.length - 1) continue;
            Log.e((String)"12345", (String)stringBuffer.toString());
            stringBuffer = new StringBuffer();
        }
        return realBuf;
    }

    public static int getStringCharacterLength(String line) {
        int length = 0;
        for (int j = 0; j < line.length(); ++j) {
            if (line.charAt(j) > '\u0100') {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static int getSubLength(String line, int width) {
        int length = 0;
        for (int j = 0; j < line.length(); ++j) {
            length = line.charAt(j) > '\u0100' ? (length += 2) : ++length;
            if (length <= width) continue;
            int temp = line.substring(0, j - 1).lastIndexOf(" ");
            if (temp != -1) {
                return temp;
            }
            return j - 1 == 0 ? 1 : j - 1;
        }
        return line.length();
    }

    public static boolean isNum(byte temp) {
        return temp >= 48 && temp <= 57;
    }

    public static void Log(String tag, String msg) {
        Log.i((String)tag, (String)msg);
        if (PrinterInstance.DEBUG) {
            // empty if block
        }
    }

    public static void Log(String tag, String msg, Throwable tr) {
        if (PrinterInstance.DEBUG) {
            Log.e((String)tag, (String)msg, (Throwable)tr);
        }
    }

    public static void writeErrorToExtStorage(String str) {
        try {
            String path = Environment.getExternalStoragePublicDirectory((String)"") + "/androidprinterdemo/";
            String fileName = "info.txt";
            File file = new File(path);
            if (!file.exists()) {
                boolean bl = file.mkdir();
            }
            FileWriter fw = new FileWriter(path + fileName, true);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(str);
            bw.close();
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

