/*
 * Decompiled with CFR 0.152.
 */
package com.mht.print.sdk.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothSocket;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.mht.print.sdk.IPrinterPort;
import com.mht.print.sdk.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;

public class BluetoothPort
implements IPrinterPort {
    private static final String TAG = BluetoothPort.class.getSimpleName();
    private BluetoothDevice mDevice;
    private BluetoothSocket mSocket;
    private BluetoothAdapter mAdapter;
    private ConnectThread mConnectThread;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Context mContext;
    private Handler mHandler;
    private int connectState;
    private int printerState;
    private int readLen;
    private byte[] cacheReadBytes;
    private byte[] readBytes;
    private boolean canRead;
    private UUID PRINTER_UUID = UUID.fromString("00001101-0000-1000-8000-00805f9b34fb");
    private BroadcastReceiver boundDeviceReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.device.action.BOND_STATE_CHANGED".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (BluetoothPort.this.mDevice == null || !BluetoothPort.this.mDevice.equals((Object)device)) {
                    return;
                }
                switch (device.getBondState()) {
                    case 10: {
                        BluetoothPort.this.mContext.unregisterReceiver(BluetoothPort.this.boundDeviceReceiver);
                        BluetoothPort.this.setConnectState(102);
                        Utils.Log(TAG, "bound cancel");
                        break;
                    }
                    case 11: {
                        Utils.Log(TAG, "bounding......");
                        break;
                    }
                    case 12: {
                        Utils.Log(TAG, "bound success");
                        BluetoothPort.this.mContext.unregisterReceiver(BluetoothPort.this.boundDeviceReceiver);
                        BluetoothPort.this.PairOrConnect(false);
                    }
                }
            }
        }
    };
    private BroadcastReceiver bluetoothStateReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (null != action) {
                block5 : switch (action) {
                    case "android.bluetooth.adapter.action.STATE_CHANGED": {
                        int blState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                        switch (blState) {
                            case 11: {
                                Utils.Log(TAG, "\u84dd\u7259\u6b63\u5728\u5f00\u542f");
                                break block5;
                            }
                            case 12: {
                                Utils.Log(TAG, "\u84dd\u7259\u5df2\u7ecf\u5f00\u542f");
                                break block5;
                            }
                            case 13: {
                                Utils.Log(TAG, "\u84dd\u7259\u6b63\u5728\u5173\u95ed");
                                break block5;
                            }
                            case 10: {
                                Utils.Log(TAG, "\u84dd\u7259\u5df2\u7ecf\u5173\u95ed");
                                if (BluetoothPort.this.getConnectState() != 101) break block5;
                                BluetoothPort.this.close();
                                break block5;
                            }
                            case -2147483648: {
                                Utils.Log(TAG, "\u84dd\u7259\u72b6\u6001\u6709\u8bef");
                                break block5;
                            }
                        }
                        break;
                    }
                    case "android.bluetooth.device.action.ACL_DISCONNECTED": {
                        Utils.Log(TAG, "\u84dd\u7259\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00");
                        if (BluetoothPort.this.getConnectState() != 101) break;
                        BluetoothPort.this.close();
                        break;
                    }
                    case "android.bluetooth.device.action.ACL_CONNECTED": {
                        Utils.Log(TAG, "\u84dd\u7259\u5df2\u8fde\u63a5");
                        if (BluetoothPort.this.getConnectState() == 101) break;
                        BluetoothPort.this.setConnectState(101);
                    }
                }
            }
        }
    };

    private void startThreadToReadData() {
        this.cacheReadBytes = new byte[1024];
        this.canRead = true;
        new Thread(() -> {
            while (this.canRead) {
                if (this.inputStream == null || this.mSocket == null || !this.mSocket.isConnected()) {
                    this.canRead = false;
                    Log.e((String)TAG, (String)"\u8bfb\u53d6\u6570\u636e\u7ebf\u7a0b\u5173\u95ed");
                    break;
                }
                this.readPacketData();
            }
        }).start();
        Log.e((String)TAG, (String)"\u5f00\u542f\u8bfb\u53d6\u6570\u636e\u7ebf\u7a0b");
    }

    private void readPacketData() {
        try {
            int readLength = this.inputStream.read(this.cacheReadBytes);
            if (readLength == -1) {
                Log.e((String)TAG, (String)"readPacketData\uff1a\u8fd4\u56de-1");
            } else {
                this.readBytes = new byte[readLength];
                byte[] copyCacheReadBytes = this.cacheReadBytes;
                System.arraycopy(copyCacheReadBytes, 0, this.readBytes, 0, readLength);
                String bytesToHexString = Utils.bytesToHexString(this.readBytes);
                int length = bytesToHexString.length();
                if (length >= 6) {
                    bytesToHexString = bytesToHexString.substring(length - 4, length);
                }
                switch (bytesToHexString) {
                    case "00": 
                    case "1E": 
                    case "32": 
                    case "72": 
                    case "1252": 
                    case "1652": {
                        this.setPrinterState(108);
                        break;
                    }
                    case "01": 
                    case "12": 
                    case "1212": {
                        this.setPrinterState(107);
                        break;
                    }
                    case "02": 
                    case "03": 
                    case "36": 
                    case "1612": {
                        this.setPrinterState(106);
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BluetoothPort(Context context, BluetoothDevice device, Handler handler) {
        this.mHandler = handler;
        this.mDevice = device;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.connectState = 103;
        this.printerState = 105;
        this.mContext = context;
    }

    public BluetoothPort(Context context, String address, Handler handler) {
        this.mHandler = handler;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mDevice = this.mAdapter.getRemoteDevice(address);
        this.connectState = 103;
        this.printerState = 105;
        this.mContext = context;
    }

    @Override
    public void open() {
        if (this.connectState != 103) {
            this.close();
        }
        if (this.mDevice != null && this.mDevice.getBondState() == 10) {
            Log.i((String)TAG, (String)"device.getBondState() is BluetoothDevice.BOND_NONE");
            this.PairOrConnect(true);
        } else if (this.mDevice != null && this.mDevice.getBondState() == 12) {
            this.PairOrConnect(false);
        }
    }

    private void PairOrConnect(boolean pair) {
        if (pair) {
            IntentFilter boundFilter = new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED");
            this.mContext.registerReceiver(this.boundDeviceReceiver, boundFilter);
            boolean success = false;
            try {
                Method e = BluetoothDevice.class.getMethod("createBond", new Class[0]);
                success = (Boolean)e.invoke((Object)this.mDevice, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            Log.i((String)TAG, (String)("createBond is success? : " + success));
        } else {
            IntentFilter stateFilter = new IntentFilter();
            stateFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            stateFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
            stateFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
            this.mContext.registerReceiver(this.bluetoothStateReceiver, stateFilter);
            this.mConnectThread = new ConnectThread();
            this.mConnectThread.start();
        }
    }

    @TargetApi(value=10)
    private boolean ReTryConnect() {
        Utils.Log(TAG, "android SDK version is:" + Build.VERSION.SDK_INT);
        try {
            if (Build.VERSION.SDK_INT >= 15) {
                this.mSocket = this.mDevice.createInsecureRfcommSocketToServiceRecord(this.PRINTER_UUID);
            } else {
                Method e = this.mDevice.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                this.mSocket = (BluetoothSocket)e.invoke((Object)this.mDevice, 1);
            }
            if (this.mSocket != null) {
                this.mSocket.connect();
            }
            return false;
        }
        catch (Exception e1) {
            Utils.Log(TAG, "connect failed:createInsecureRfcommSocketToServiceRecord");
            try {
                Method e = this.mDevice.getClass().getMethod("createRfcommSocket", Integer.TYPE);
                this.mSocket = (BluetoothSocket)e.invoke((Object)this.mDevice, 1);
                if (this.mSocket != null) {
                    this.mSocket.connect();
                }
            }
            catch (Exception e) {
                Utils.Log(TAG, "connect failed:createRfcommSocket");
                e.printStackTrace();
            }
            e1.printStackTrace();
            return true;
        }
    }

    @Override
    public void close() {
        Utils.Log(TAG, "close()");
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (IOException e) {
            Utils.Log(TAG, "close socket failed");
            e.printStackTrace();
        }
        this.mConnectThread = null;
        this.mDevice = null;
        this.mSocket = null;
        this.setPrinterState(105);
        if (this.connectState != 102) {
            this.setConnectState(103);
        }
        try {
            if (this.bluetoothStateReceiver != null && this.mContext != null) {
                Utils.Log(TAG, "unregisterReceiver:bluetoothStateReceiver");
                this.mContext.unregisterReceiver(this.bluetoothStateReceiver);
            }
        }
        catch (Exception e) {
            Utils.Log(TAG, "unregisterReceiver bluetoothStateReceiver failed");
            e.printStackTrace();
        }
    }

    @Override
    public int write(byte[] bytes) {
        try {
            if (this.outputStream != null) {
                this.outputStream.write(bytes);
                this.outputStream.flush();
                return 0;
            }
            return -1;
        }
        catch (IOException e) {
            Utils.Log(TAG, "write error.");
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public byte[] read() {
        byte[] readBuff = null;
        try {
            if (this.inputStream != null && (this.readLen = this.inputStream.available()) > 0) {
                readBuff = new byte[this.readLen];
                int n = this.inputStream.read(readBuff);
            }
        }
        catch (IOException e) {
            Utils.Log(TAG, "read error");
            e.printStackTrace();
        }
        Log.w((String)TAG, (String)("read length:" + this.readLen));
        return readBuff;
    }

    public synchronized byte[] read(int timeout) {
        byte[] receiveBytes = null;
        try {
            while ((this.readLen = this.inputStream.available()) <= 0 && (timeout -= 50) > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Log.e((String)TAG, (String)"read error:", (Throwable)e);
                }
            }
            if (this.readLen > 0) {
                receiveBytes = new byte[this.readLen];
                this.inputStream.read(receiveBytes);
            }
        }
        catch (IOException e) {
            Utils.Log(TAG, "read error:", e);
        }
        return receiveBytes;
    }

    private synchronized void setConnectState(int state) {
        Utils.Log(TAG, "setConnectState() " + this.connectState + " -> " + state);
        if (this.connectState != state) {
            this.connectState = state;
            if (this.mHandler != null) {
                this.mHandler.obtainMessage(this.connectState).sendToTarget();
            }
        }
    }

    private synchronized void setPrinterState(int state) {
        Utils.Log(TAG, "setPrinterState() " + this.printerState + " -> " + state);
        if (this.printerState != state) {
            this.printerState = state;
        }
    }

    @Override
    public int getConnectState() {
        return this.connectState;
    }

    @Override
    public int getPrinterState() {
        return this.printerState;
    }

    private class ConnectThread
    extends Thread {
        private ConnectThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean hasError = false;
            BluetoothPort.this.mAdapter.cancelDiscovery();
            try {
                BluetoothPort.this.mSocket = BluetoothPort.this.mDevice.createRfcommSocketToServiceRecord(BluetoothPort.this.PRINTER_UUID);
                BluetoothPort.this.mSocket.connect();
            }
            catch (IOException e) {
                Utils.Log(TAG, "ConnectThread failed. retry.");
                e.printStackTrace();
                hasError = BluetoothPort.this.ReTryConnect();
            }
            ConnectThread e = this;
            synchronized (e) {
                BluetoothPort.this.mConnectThread = null;
            }
            if (!hasError) {
                try {
                    BluetoothPort.this.inputStream = BluetoothPort.this.mSocket.getInputStream();
                    BluetoothPort.this.outputStream = BluetoothPort.this.mSocket.getOutputStream();
                }
                catch (IOException e2) {
                    hasError = true;
                    Utils.Log(TAG, "Get Stream failed");
                    e2.printStackTrace();
                }
            }
            if (hasError) {
                BluetoothPort.this.setConnectState(102);
                BluetoothPort.this.close();
            } else {
                BluetoothPort.this.setConnectState(101);
            }
        }
    }
}

