/*
 * Decompiled with CFR 0.152.
 */
package com.mht.print.sdk;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class TsplCommand {
    private static final String TAG = TsplCommand.class.getSimpleName();
    private byte[] command = new byte[0];

    private void addCommand(byte[] newCommand) {
        byte[] mergerCommand = new byte[this.command.length + newCommand.length];
        System.arraycopy(this.command, 0, mergerCommand, 0, this.command.length);
        System.arraycopy(newCommand, 0, mergerCommand, this.command.length, newCommand.length);
        this.command = mergerCommand;
    }

    public byte[] getCommand() {
        return this.command;
    }

    public void setBitmap(int x, int y, int concentration, Bitmap bitmap) {
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        String bitmapCommand = "BITMAP " + x + "," + y + "," + width / 8 + "," + height + ",1,";
        this.addCommand(bitmapCommand.getBytes());
        byte[] bitmapData = TsplCommand.convertToBMW(bitmap, concentration);
        this.addCommand(bitmapData);
    }

    public void setBitmap(int x, int y, Bitmap bitmap) {
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        String bitmapCommand = "BITMAP " + x + "," + y + "," + width / 8 + "," + height + ",1,";
        this.addCommand(bitmapCommand.getBytes());
        byte[] bitmapData = TsplCommand.convertToBMW(bitmap, 128);
        this.addCommand(bitmapData);
    }

    public void setPrintNumber(int number) {
        if (number < 1) {
            number = 1;
        }
        String printCommand = "PRINT 1," + number + "\r\n";
        this.addCommand(printCommand.getBytes());
    }

    public void initCanvas(int width, int height) {
        byte[] data = ("SIZE " + width + " mm," + height + " mm\r\n").getBytes();
        this.addCommand(data);
    }

    public void clearCanvas() {
        byte[] bytes = "CLS\r\n".getBytes();
        this.addCommand(bytes);
    }

    public void setDirection(int direction) {
        byte[] bytes = ("DIRECTION " + direction + "\r\n").getBytes();
        this.addCommand(bytes);
    }

    public void setSpeed(int speed) {
        byte[] bytes = ("SPEED " + speed + "\r\n").getBytes();
        this.addCommand(bytes);
    }

    public void setDensity(int density) {
        byte[] bytes = ("DENSITY " + density + "\r\n").getBytes();
        this.addCommand(bytes);
    }

    public void setText(int x, int y, int fontWidth, int fontHeight, String content) {
        byte[] bytes = new byte[]{};
        try {
            bytes = ("TEXT " + x + "," + y + ",\"TSS24.BF2\",0," + fontWidth + "," + fontHeight + ",\"" + content + "\"\r\n").getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        this.addCommand(bytes);
    }

    public void setText(int labelWidth, int y, int fontWidth, int fontHeight, int alignments, String content) {
        if (labelWidth <= 0 || content.length() <= 0) {
            return;
        }
        try {
            byte[] contentBytes = content.getBytes("GBK");
            int everyLineByteCount = labelWidth * 8 / (12 * fontWidth);
            if (contentBytes.length >= everyLineByteCount) {
                this.setMultilineText(labelWidth, 0, y, fontWidth, fontHeight, 0, content);
                return;
            }
            int x = 0;
            switch (alignments) {
                case 0: {
                    x = 0;
                    break;
                }
                case 1: {
                    x = (everyLineByteCount - contentBytes.length) / 2 * 12 * fontWidth;
                    break;
                }
                case 2: {
                    x = (everyLineByteCount - contentBytes.length) * 12 * fontWidth;
                    break;
                }
            }
            this.setText(x, y, fontWidth, fontHeight, content);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public void setMultilineText(int labelWidth, int x, int y, int fontWidth, int fontHeight, int space, String content) {
        if (labelWidth <= 0 || content.length() <= 0) {
            return;
        }
        try {
            byte[] contentBytes = content.getBytes("GBK");
            int everyLineByteCount = (int)(((double)(labelWidth * 8) - Math.ceil((double)x / 24.0) * 24.0) / (double)(12 * fontWidth));
            int lines = (int)Math.ceil((double)contentBytes.length / (double)everyLineByteCount);
            int endY = y;
            ByteBuffer byteBuffer = ByteBuffer.wrap(contentBytes);
            for (int i = 0; i < lines; ++i) {
                byte[] newByte = i == lines - 1 ? new byte[contentBytes.length - i * everyLineByteCount] : new byte[everyLineByteCount];
                byteBuffer.get(newByte, 0, newByte.length);
                String tempString = new String(newByte, "GBK");
                byte[] tempByte = ("TEXT " + x + "," + endY + ",\"TSS24.BF2\",0," + fontWidth + "," + fontHeight + ",\"" + tempString + "\"\r\n").getBytes("GBK");
                this.addCommand(tempByte);
                endY = endY + fontHeight * 24 + space;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public void setBarCode(int x, int y, String codeType, int height, int narrow, int barcodeTextAlign, int rotation, String content) {
        byte[] bytes = new byte[]{};
        try {
            bytes = ("BARCODE " + x + "," + y + ",\"" + codeType + "\"," + height + "," + barcodeTextAlign + "," + rotation + "," + narrow + ",2,\"" + content + "\"\n").getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        this.addCommand(bytes);
    }

    public void setQrCode(int x, int y, String level, int width, int rotation, String content) {
        byte[] bytes = new byte[]{};
        try {
            bytes = ("QRCODE " + x + "," + y + "," + level + "," + width + ",M," + rotation + ",M1,S1,\"" + content + "\"\n").getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        this.addCommand(bytes);
    }

    public void setSound(int level, int interval) {
        byte[] bytes = new byte[]{};
        try {
            bytes = ("SOUND " + level + "," + interval + "\n").getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
        this.addCommand(bytes);
    }

    public static byte[] convertToBMW(Bitmap bmp, int concentration) {
        if (concentration <= 0 || concentration >= 255) {
            concentration = 128;
        }
        int width = bmp.getWidth();
        int height = bmp.getHeight();
        byte[] bytes = new byte[width / 8 * height];
        int[] p = new int[8];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width / 8; ++j) {
                byte value;
                for (int z = 0; z < 8; ++z) {
                    int blue;
                    int green;
                    int grey = bmp.getPixel(j * 8 + z, i);
                    int red = (grey & 0xFF0000) >> 16;
                    int gray = (int)(0.299 * (double)red + 0.587 * (double)(green = (grey & 0xFF00) >> 8) + 0.114 * (double)(blue = grey & 0xFF));
                    gray = gray <= concentration ? 0 : 1;
                    p[z] = gray;
                }
                bytes[width / 8 * i + j] = value = (byte)(p[0] * 128 + p[1] * 64 + p[2] * 32 + p[3] * 16 + p[4] * 8 + p[5] * 4 + p[6] * 2 + p[7]);
            }
        }
        return bytes;
    }
}

