/*
 * Decompiled with CFR 0.152.
 */
package com.mht.print.sdk;

import android.annotation.SuppressLint;
import com.mht.print.sdk.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"UseSparseArrays"})
public class Table {
    private final List<String> tableRows = new ArrayList<String>();
    private final String tableReg;
    private final HashMap<Integer, String> unPrintColumnMap = new HashMap();
    private final int[] tableColWidth;
    private boolean alignRight;

    public Table(String column, String regularExpression, int[] columnWidth) {
        this.tableRows.add(column);
        this.tableReg = regularExpression;
        if (columnWidth != null) {
            this.tableColWidth = columnWidth;
        } else {
            this.tableColWidth = new int[column.split(regularExpression).length];
            Arrays.fill(this.tableColWidth, 8);
        }
    }

    public void setColumnAlignRight(boolean right) {
        this.alignRight = right;
    }

    public void addRow(String row) {
        this.tableRows.add(row);
    }

    public String getTableText() {
        StringBuilder sb = new StringBuilder();
        for (int m = 0; m < this.tableRows.size(); ++m) {
            String[] tableLine = this.tableRows.get(m).split(this.tableReg);
            sb.append(this.printTableLine(tableLine));
            sb.append("\n");
        }
        return sb.toString();
    }

    private String printTableLine(String[] tableLine) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tableLine.length; ++i) {
            int j;
            tableLine[i] = tableLine[i].trim();
            int index = tableLine[i].indexOf("\n");
            if (index != -1) {
                this.unPrintColumnMap.put(i, tableLine[i].substring(index + 1));
                tableLine[i] = tableLine[i].substring(0, index);
                sb.append(this.printTableLine(tableLine));
                sb.append(this.printNewLine(tableLine));
                return sb.toString();
            }
            int length = Utils.getStringCharacterLength(tableLine[i]);
            int colLength = this.tableColWidth.length;
            int colWidth = 8;
            if (i < colLength) {
                colWidth = this.tableColWidth[i];
            }
            if (length > colWidth && i != tableLine.length - 1) {
                int subLength = Utils.getSubLength(tableLine[i], colWidth);
                this.unPrintColumnMap.put(i, tableLine[i].substring(subLength));
                tableLine[i] = tableLine[i].substring(0, subLength);
                sb = new StringBuffer();
                sb.append(this.printTableLine(tableLine));
                sb.append(this.printNewLine(tableLine));
                return sb.toString();
            }
            if (i == 0) {
                sb.append(tableLine[i]);
                for (j = 0; j < colWidth - length; ++j) {
                    sb.append(" ");
                }
                continue;
            }
            if (this.alignRight) {
                for (j = 0; j < colWidth - length; ++j) {
                    sb.append(" ");
                }
                sb.append(tableLine[i]);
                continue;
            }
            sb.append(tableLine[i]);
            for (j = 0; j < colWidth - length; ++j) {
                if (i == tableLine.length - 1) continue;
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    private String printNewLine(String[] oldLine) {
        if (this.unPrintColumnMap.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] newLine = new String[oldLine.length];
        for (Map.Entry<Integer, String> i : this.unPrintColumnMap.entrySet()) {
            Integer key = i.getKey();
            String value = i.getValue();
            if (key >= oldLine.length) continue;
            newLine[key.intValue()] = value;
        }
        this.unPrintColumnMap.clear();
        for (int i = 0; i < newLine.length; ++i) {
            if (newLine[i] != null && !"".equals(newLine[i])) continue;
            newLine[i] = " ";
        }
        sb.append(this.printTableLine(newLine));
        return "\n" + sb.toString();
    }
}

