/*
 * Decompiled with CFR 0.152.
 */
package com.mht.print.sdk;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.graphics.Bitmap;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import com.mht.print.sdk.Barcode;
import com.mht.print.sdk.IPrinterPort;
import com.mht.print.sdk.Table;
import com.mht.print.sdk.TsplCommand;
import com.mht.print.sdk.bluetooth.BluetoothPort;
import com.mht.print.sdk.usb.USBPort;
import com.mht.print.sdk.util.Utils;
import com.mht.print.sdk.wifi.WiFiPort;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class PrinterInstance
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static boolean DEBUG = false;
    private static final String TAG = PrinterInstance.class.getSimpleName();
    private final IPrinterPort myPrinter;
    private String charsetName = "gbk";
    private final Handler handler;

    public PrinterInstance(Context context, BluetoothDevice bluetoothDevice, Handler handler) {
        this.myPrinter = new BluetoothPort(context, bluetoothDevice, handler);
        this.handler = handler;
    }

    public PrinterInstance(Context context, String macAddress, Handler handler) {
        this.myPrinter = new BluetoothPort(context, macAddress, handler);
        this.handler = handler;
    }

    public PrinterInstance(Context context, UsbDevice usbDevice, Handler handler) {
        this.myPrinter = new USBPort(context, usbDevice, handler);
        this.handler = handler;
    }

    public PrinterInstance(String ipAddress, int portNumber, Handler handler) {
        this.myPrinter = new WiFiPort(ipAddress, portNumber, handler);
        this.handler = handler;
    }

    public String getEncoding() {
        return this.charsetName;
    }

    public void setEncoding(String charsetName) {
        this.charsetName = charsetName;
    }

    public boolean isConnected() {
        return this.myPrinter.getConnectState() == 101;
    }

    public void openConnection() {
        this.myPrinter.open();
    }

    public void closeConnection() {
        this.myPrinter.close();
    }

    public int printText(String content) {
        byte[] data = null;
        try {
            data = !"".equals(this.charsetName) ? content.getBytes(this.charsetName) : content.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.sendByteData(data);
    }

    public int sendByteData(byte[] data) {
        if (data != null) {
            return this.myPrinter.write(data);
        }
        return -1;
    }

    public int printEscImage(Bitmap bitmap) {
        return this.sendByteData(Utils.escBitmapPrint(bitmap));
    }

    @Deprecated
    public int printImage(Bitmap bitmap, int left) {
        return this.sendByteData(Utils.bitmap2PrinterBytes(bitmap, left));
    }

    public int printLabelImage(int labelWidth, int labelHeight, Bitmap bitmap) {
        TsplCommand tsplCommand = new TsplCommand();
        tsplCommand.initCanvas(labelWidth, labelHeight);
        tsplCommand.clearCanvas();
        tsplCommand.setDirection(0);
        tsplCommand.setBitmap(0, 0, 128, bitmap);
        tsplCommand.setPrintNumber(1);
        return this.sendByteData(tsplCommand.getCommand());
    }

    public int printLabelImage(int labelWidth, int labelHeight, int direction, int number, int x, int y, Bitmap bitmap) {
        TsplCommand tsplCommand = new TsplCommand();
        tsplCommand.initCanvas(labelWidth, labelHeight);
        tsplCommand.clearCanvas();
        tsplCommand.setDirection(direction);
        tsplCommand.setBitmap(x, y, 128, bitmap);
        tsplCommand.setPrintNumber(number);
        return this.sendByteData(tsplCommand.getCommand());
    }

    public int printLabel(TsplCommand tsplCommand) {
        return this.sendByteData(tsplCommand.getCommand());
    }

    public int printTable(Table table) {
        return this.printText(table.getTableText());
    }

    public int printBarCode(Barcode barcode) {
        return this.sendByteData(barcode.getBarcodeData());
    }

    public void init() {
        this.setPrinter(0);
    }

    public byte[] read() {
        return this.myPrinter.read();
    }

    public byte[] read(int timeout) {
        if (this.myPrinter instanceof BluetoothPort) {
            BluetoothPort bluetoothPort = (BluetoothPort)this.myPrinter;
            return bluetoothPort.read(timeout);
        }
        return this.myPrinter.read();
    }

    public int getPrinterStatus() {
        return this.myPrinter.getPrinterState();
    }

    public String getPrinterStatus2() {
        try {
            int write = this.myPrinter.write(new byte[]{16, 4, 2, 16, 4, 3, 16, 4, 4});
            Utils.Log("getPrinterStatus", "write result:" + write + "\n");
            if (write != -1) {
                int i = 0;
                while (i < 5) {
                    Thread.sleep(50L);
                    byte[] read = this.read();
                    if (read != null) {
                        String hexString = Utils.bytesToHexString(read);
                        Utils.Log("getPrinterStatus", "\u6253\u5370\u673a\u8fd4\u56de:" + hexString + "\n");
                        return hexString;
                    }
                    Utils.Log("getPrinterStatus", "\u4e0b\u4e00\u6b21\uff1a" + ++i + "\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "\u672a\u77e5";
    }

    public synchronized void sendBytesToRead(byte[] bytes, int time, int number, final SendBytesToReadCallBack sendBytesToReadCallBack) {
        try {
            if (time * number > 20000) {
                time = 500;
                number = 40;
            }
            this.read();
            this.read();
            int write = this.myPrinter.write(bytes);
            if (write != -1) {
                for (int i = 0; i < number; ++i) {
                    Thread.sleep(time);
                    if (this.myPrinter.getConnectState() == 101) {
                        final byte[] read = this.read();
                        if (read == null) continue;
                        this.handler.post(new Runnable(){

                            @Override
                            public void run() {
                                if (sendBytesToReadCallBack != null) {
                                    sendBytesToReadCallBack.callBytes(read);
                                }
                            }
                        });
                        return;
                    }
                    this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (sendBytesToReadCallBack != null) {
                                sendBytesToReadCallBack.callError(3);
                            }
                        }
                    });
                    return;
                }
            }
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (sendBytesToReadCallBack != null) {
                        sendBytesToReadCallBack.callError(1);
                    }
                }
            });
        }
        catch (Exception e) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (sendBytesToReadCallBack != null) {
                        sendBytesToReadCallBack.callError(2);
                    }
                }
            });
        }
    }

    public boolean setPrinter(int command) {
        byte[] arrayOfByte = null;
        switch (command) {
            case 0: {
                arrayOfByte = new byte[]{27, 64};
                break;
            }
            case 1: {
                arrayOfByte = new byte[]{0};
                break;
            }
            case 2: {
                arrayOfByte = new byte[]{12};
                break;
            }
            case 3: {
                arrayOfByte = new byte[]{10};
                break;
            }
            case 4: {
                arrayOfByte = new byte[]{13};
                break;
            }
            case 5: {
                arrayOfByte = new byte[]{9};
                break;
            }
            case 6: {
                arrayOfByte = new byte[]{27, 50};
            }
        }
        this.sendByteData(arrayOfByte);
        return true;
    }

    public boolean setPrinter(int command, int value) {
        byte[] arrayOfByte = new byte[3];
        switch (command) {
            case 0: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 74;
                break;
            }
            case 1: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 100;
                break;
            }
            case 2: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 33;
                break;
            }
            case 3: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 86;
                break;
            }
            case 4: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 45;
                break;
            }
            case 5: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 99;
                break;
            }
            case 6: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 51;
                break;
            }
            case 7: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 32;
                break;
            }
            case 8: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 97;
                if (value <= 2 && value >= 0) break;
                return false;
            }
            case 9: {
                arrayOfByte[0] = 27;
                arrayOfByte[1] = 69;
            }
        }
        arrayOfByte[2] = (byte)value;
        this.sendByteData(arrayOfByte);
        return true;
    }

    public void setCharacterMultiple(int x, int y) {
        byte[] arrayOfByte = new byte[]{29, 33, 0};
        if (x >= 0 && x <= 7 && y >= 0 && y <= 7) {
            arrayOfByte[2] = (byte)(x * 16 + y);
            this.sendByteData(arrayOfByte);
        }
    }

    public void setLeftMargin(int nL, int nH) {
        byte[] arrayOfByte = new byte[]{29, 76, (byte)nL, (byte)nH};
        this.sendByteData(arrayOfByte);
    }

    public void setPrintModel(boolean smallFont, boolean isBold, boolean isDoubleHeight, boolean isDoubleWidth, boolean isUnderLine) {
        byte[] arrayOfByte = new byte[]{27, 33, 0};
        int a = 0;
        if (smallFont) {
            ++a;
        }
        if (isBold) {
            a += 8;
        }
        if (isDoubleHeight) {
            a += 16;
        }
        if (isDoubleWidth) {
            a += 32;
        }
        if (isUnderLine) {
            a += 128;
        }
        arrayOfByte[2] = (byte)a;
        this.sendByteData(arrayOfByte);
    }

    public void cutPaper() {
        byte[] cutCommand = new byte[]{29, 86, 66, 0};
        this.sendByteData(cutCommand);
    }

    public void ringBuzzer(byte number, byte time) {
        byte[] buzzerCommand = new byte[]{27, 66, number, time};
        this.sendByteData(buzzerCommand);
    }

    public void openCashbox(boolean cashbox1, boolean cashbox2) {
        byte[] drawCommand;
        if (cashbox1) {
            drawCommand = new byte[]{27, 112, 0, 50, 50};
            this.sendByteData(drawCommand);
        }
        if (cashbox2) {
            drawCommand = new byte[]{27, 112, 1, 50, 50};
            this.sendByteData(drawCommand);
        }
    }

    public static interface SendBytesToReadCallBack {
        public void callBytes(byte[] var1);

        public void callError(int var1);
    }
}

