/*
 * Decompiled with CFR 0.152.
 */
package com.mht.print.sdk;

import com.mht.print.sdk.PrinterInstance;
import com.mht.print.sdk.util.Utils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class Barcode {
    private static final String TAG = Barcode.class.getSimpleName();
    private byte barcodeType;
    private int barcodeWidth;
    private int barcodeHeight;
    private int barcodePosition;
    private int qrcodeSize;
    private String content;
    private String charsetName = "gbk";

    public Barcode(byte barcodeType) {
        this.barcodeType = barcodeType;
    }

    public Barcode(byte barcodeType, int barcodeWidth, int barcodeHeight, int barcodePosition) {
        this.barcodeType = barcodeType;
        this.barcodeWidth = barcodeWidth;
        this.barcodeHeight = barcodeHeight;
        this.barcodePosition = barcodePosition;
    }

    public Barcode(byte barcodeType, int barcodeWidth, int barcodeHeight, int barcodePosition, String content) {
        this.barcodeType = barcodeType;
        this.barcodeWidth = barcodeWidth;
        this.barcodeHeight = barcodeHeight;
        this.barcodePosition = barcodePosition;
        this.content = content;
    }

    public void setBarcodeParam(byte barcodeWidth, byte barcodeHeight, byte barcodePosition) {
        this.barcodeWidth = barcodeWidth;
        this.barcodeHeight = barcodeHeight;
        this.barcodePosition = barcodePosition;
    }

    public void setQrcodeSize(int qrcodeSize) {
        this.qrcodeSize = qrcodeSize;
    }

    public void setBarcodeContent(String content) {
        this.content = content;
    }

    public void setBarcodeContent(String content, String charsetName) {
        this.content = content;
        this.charsetName = charsetName;
    }

    public byte[] getBarcodeData() {
        int j;
        byte[] realCommand;
        switch (this.barcodeType) {
            case 72: {
                realCommand = this.getBarcodeCommand1(this.content, this.barcodeType, (byte)this.content.length());
                break;
            }
            case 73: {
                int temp;
                byte[] sb = new byte[1024];
                j = 0;
                int tempLength = temp = this.content.length();
                char[] charArray = this.content.toCharArray();
                boolean preHasCodeA = false;
                boolean preHasCodeB = false;
                boolean preHasCodeC = false;
                boolean needCodeC = false;
                for (int i = 0; i < temp; ++i) {
                    byte a = (byte)charArray[i];
                    if (a >= 0 && a <= 31) {
                        if (i == 0 || !preHasCodeA) {
                            sb[j++] = 123;
                            sb[j++] = 65;
                            preHasCodeA = true;
                            preHasCodeB = false;
                            preHasCodeC = false;
                            tempLength += 2;
                        }
                        sb[j++] = a;
                        continue;
                    }
                    if (a >= 48 && a <= 57) {
                        int b;
                        if (!preHasCodeC) {
                            for (b = 1; b < 9; ++b) {
                                if (i + b == temp || !Utils.isNum((byte)charArray[i + b])) {
                                    needCodeC = false;
                                    break;
                                }
                                if (b != 8) continue;
                                needCodeC = true;
                            }
                        }
                        if (needCodeC) {
                            if (!preHasCodeC) {
                                sb[j++] = 123;
                                sb[j++] = 67;
                                preHasCodeA = false;
                                preHasCodeB = false;
                                preHasCodeC = true;
                                tempLength += 2;
                            }
                            if (i != temp - 1 && Utils.isNum((byte)(b = (int)((byte)charArray[i + 1])))) {
                                sb[j++] = (byte)((a - 48) * 10 + (b - 48));
                                --tempLength;
                                ++i;
                                continue;
                            }
                        }
                    }
                    if (!preHasCodeB) {
                        sb[j++] = 123;
                        sb[j++] = 66;
                        preHasCodeA = false;
                        preHasCodeB = true;
                        preHasCodeC = false;
                        tempLength += 2;
                    }
                    sb[j++] = a;
                }
                realCommand = this.getBarcodeCommand1(new String(sb, 0, tempLength), this.barcodeType, (byte)tempLength);
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                realCommand = this.getBarcodeCommand3(this.content, this.qrcodeSize);
                break;
            }
            default: {
                realCommand = this.getBarcodeCommand1(this.content, this.barcodeType);
            }
        }
        if (PrinterInstance.DEBUG) {
            StringBuilder builder = new StringBuilder();
            for (j = 0; j < realCommand.length; ++j) {
                String toHexString = Integer.toHexString(realCommand[j] & 0xFF);
                if (toHexString.length() == 1) {
                    toHexString = "0" + toHexString;
                }
                builder.append(toHexString).append(" ");
            }
            Utils.Log(TAG, "bar code command: " + builder.toString());
        }
        return realCommand;
    }

    private byte[] getBarcodeCommand1(String content, byte ... byteArray) {
        int j;
        byte[] tmpByte;
        int index = 0;
        try {
            tmpByte = !"".equals(this.charsetName) ? content.getBytes(this.charsetName) : content.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        byte[] command = new byte[tmpByte.length + 13];
        int i = index + 1;
        command[index] = 29;
        command[i++] = 119;
        command[i++] = this.barcodeWidth >= 2 && this.barcodeWidth <= 6 ? (int)this.barcodeWidth : 2;
        command[i++] = 29;
        command[i++] = 104;
        command[i++] = this.barcodeHeight >= 1 && this.barcodeHeight <= 255 ? (int)this.barcodeHeight : -94;
        command[i++] = 29;
        command[i++] = 72;
        command[i++] = this.barcodePosition >= 0 && this.barcodePosition <= 3 ? (byte)this.barcodePosition : (byte)0;
        command[i++] = 29;
        command[i++] = 107;
        for (j = 0; j < byteArray.length; ++j) {
            command[i++] = byteArray[j];
        }
        for (j = 0; j < tmpByte.length; ++j) {
            command[i++] = tmpByte[j];
        }
        return command;
    }

    private byte[] getBarcodeCommand2(String content, byte barcodeType, int param1, int param2, int param3) {
        byte[] tmpByte;
        try {
            tmpByte = !"".equals(this.charsetName) ? content.getBytes(this.charsetName) : content.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        byte[] command = new byte[tmpByte.length + 10];
        command[0] = 29;
        command[1] = 90;
        command[2] = (byte)(barcodeType - 100);
        command[3] = 27;
        command[4] = 90;
        command[5] = (byte)param1;
        command[6] = (byte)param2;
        command[7] = (byte)param3;
        command[8] = (byte)(tmpByte.length % 256);
        command[9] = (byte)(tmpByte.length / 256);
        System.arraycopy(tmpByte, 0, command, 10, tmpByte.length);
        return command;
    }

    private byte[] getBarcodeCommand3(String content, int dotSize) {
        byte[] tmpByte;
        if (dotSize > 15) {
            dotSize = 12;
        }
        if (dotSize < 0) {
            dotSize = 3;
        }
        try {
            tmpByte = !"".equals(this.charsetName) ? content.getBytes(this.charsetName) : content.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        byte[] byte1 = new byte[]{29, 40, 107, 3, 0, 49, 67, (byte)dotSize};
        byte[] byte2 = new byte[]{29, 40, 107, 3, 0, 49, 69, 48};
        byte[] command = new byte[byte1.length + byte2.length];
        System.arraycopy(byte1, 0, command, 0, byte1.length);
        System.arraycopy(byte2, 0, command, byte1.length, byte2.length);
        byte b = (byte)((tmpByte.length + 3) % 256);
        byte b1 = (byte)((tmpByte.length + 3) / 256);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(tmpByte.length + 8);
        byteBuffer.put(new byte[]{29, 40, 107, b, b1, 49, 80, 48}, 0, 8);
        byteBuffer.put(tmpByte, 0, tmpByte.length);
        byte[] array = byteBuffer.array();
        byte[] command2 = new byte[command.length + array.length];
        System.arraycopy(command, 0, command2, 0, command.length);
        System.arraycopy(array, 0, command2, command.length, array.length);
        byte[] bytes = new byte[]{29, 40, 107, 3, 0, 49, 81, 48};
        byte[] command3 = new byte[command2.length + bytes.length];
        System.arraycopy(command2, 0, command3, 0, command2.length);
        System.arraycopy(bytes, 0, command3, command2.length, bytes.length);
        return command3;
    }
}

